/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datazone.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.datazone.model.AssetTargetNameMap;
import com.amazonaws.services.datazone.model.GrantedEntityInput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateSubscriptionGrantRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private List<AssetTargetNameMap> assetTargetNames;
    private String clientToken;
    private String domainIdentifier;
    private String environmentIdentifier;
    private GrantedEntityInput grantedEntity;
    private String subscriptionTargetIdentifier;

    public List<AssetTargetNameMap> getAssetTargetNames() {
        return this.assetTargetNames;
    }

    public void setAssetTargetNames(Collection<AssetTargetNameMap> assetTargetNames) {
        if (assetTargetNames == null) {
            this.assetTargetNames = null;
            return;
        }
        this.assetTargetNames = new ArrayList<AssetTargetNameMap>(assetTargetNames);
    }

    public CreateSubscriptionGrantRequest withAssetTargetNames(AssetTargetNameMap ... assetTargetNames) {
        if (this.assetTargetNames == null) {
            this.setAssetTargetNames(new ArrayList<AssetTargetNameMap>(assetTargetNames.length));
        }
        for (AssetTargetNameMap ele : assetTargetNames) {
            this.assetTargetNames.add(ele);
        }
        return this;
    }

    public CreateSubscriptionGrantRequest withAssetTargetNames(Collection<AssetTargetNameMap> assetTargetNames) {
        this.setAssetTargetNames(assetTargetNames);
        return this;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public CreateSubscriptionGrantRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public void setDomainIdentifier(String domainIdentifier) {
        this.domainIdentifier = domainIdentifier;
    }

    public String getDomainIdentifier() {
        return this.domainIdentifier;
    }

    public CreateSubscriptionGrantRequest withDomainIdentifier(String domainIdentifier) {
        this.setDomainIdentifier(domainIdentifier);
        return this;
    }

    public void setEnvironmentIdentifier(String environmentIdentifier) {
        this.environmentIdentifier = environmentIdentifier;
    }

    public String getEnvironmentIdentifier() {
        return this.environmentIdentifier;
    }

    public CreateSubscriptionGrantRequest withEnvironmentIdentifier(String environmentIdentifier) {
        this.setEnvironmentIdentifier(environmentIdentifier);
        return this;
    }

    public void setGrantedEntity(GrantedEntityInput grantedEntity) {
        this.grantedEntity = grantedEntity;
    }

    public GrantedEntityInput getGrantedEntity() {
        return this.grantedEntity;
    }

    public CreateSubscriptionGrantRequest withGrantedEntity(GrantedEntityInput grantedEntity) {
        this.setGrantedEntity(grantedEntity);
        return this;
    }

    public void setSubscriptionTargetIdentifier(String subscriptionTargetIdentifier) {
        this.subscriptionTargetIdentifier = subscriptionTargetIdentifier;
    }

    public String getSubscriptionTargetIdentifier() {
        return this.subscriptionTargetIdentifier;
    }

    public CreateSubscriptionGrantRequest withSubscriptionTargetIdentifier(String subscriptionTargetIdentifier) {
        this.setSubscriptionTargetIdentifier(subscriptionTargetIdentifier);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAssetTargetNames() != null) {
            sb.append("AssetTargetNames: ").append(this.getAssetTargetNames()).append(",");
        }
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken()).append(",");
        }
        if (this.getDomainIdentifier() != null) {
            sb.append("DomainIdentifier: ").append(this.getDomainIdentifier()).append(",");
        }
        if (this.getEnvironmentIdentifier() != null) {
            sb.append("EnvironmentIdentifier: ").append(this.getEnvironmentIdentifier()).append(",");
        }
        if (this.getGrantedEntity() != null) {
            sb.append("GrantedEntity: ").append(this.getGrantedEntity()).append(",");
        }
        if (this.getSubscriptionTargetIdentifier() != null) {
            sb.append("SubscriptionTargetIdentifier: ").append(this.getSubscriptionTargetIdentifier());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSubscriptionGrantRequest)) {
            return false;
        }
        CreateSubscriptionGrantRequest other = (CreateSubscriptionGrantRequest)obj;
        if (other.getAssetTargetNames() == null ^ this.getAssetTargetNames() == null) {
            return false;
        }
        if (other.getAssetTargetNames() != null && !other.getAssetTargetNames().equals(this.getAssetTargetNames())) {
            return false;
        }
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        if (other.getClientToken() != null && !other.getClientToken().equals(this.getClientToken())) {
            return false;
        }
        if (other.getDomainIdentifier() == null ^ this.getDomainIdentifier() == null) {
            return false;
        }
        if (other.getDomainIdentifier() != null && !other.getDomainIdentifier().equals(this.getDomainIdentifier())) {
            return false;
        }
        if (other.getEnvironmentIdentifier() == null ^ this.getEnvironmentIdentifier() == null) {
            return false;
        }
        if (other.getEnvironmentIdentifier() != null && !other.getEnvironmentIdentifier().equals(this.getEnvironmentIdentifier())) {
            return false;
        }
        if (other.getGrantedEntity() == null ^ this.getGrantedEntity() == null) {
            return false;
        }
        if (other.getGrantedEntity() != null && !other.getGrantedEntity().equals(this.getGrantedEntity())) {
            return false;
        }
        if (other.getSubscriptionTargetIdentifier() == null ^ this.getSubscriptionTargetIdentifier() == null) {
            return false;
        }
        return other.getSubscriptionTargetIdentifier() == null || other.getSubscriptionTargetIdentifier().equals(this.getSubscriptionTargetIdentifier());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAssetTargetNames() == null ? 0 : this.getAssetTargetNames().hashCode());
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        hashCode = 31 * hashCode + (this.getDomainIdentifier() == null ? 0 : this.getDomainIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getEnvironmentIdentifier() == null ? 0 : this.getEnvironmentIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getGrantedEntity() == null ? 0 : this.getGrantedEntity().hashCode());
        hashCode = 31 * hashCode + (this.getSubscriptionTargetIdentifier() == null ? 0 : this.getSubscriptionTargetIdentifier().hashCode());
        return hashCode;
    }

    public CreateSubscriptionGrantRequest clone() {
        return (CreateSubscriptionGrantRequest)super.clone();
    }
}

