/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dax.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.dax.model.transform.EndpointMarshaller;
import java.io.Serializable;

public class Endpoint
implements Serializable,
Cloneable,
StructuredPojo {
    private String address;
    private Integer port;
    private String uRL;

    public void setAddress(String address) {
        this.address = address;
    }

    public String getAddress() {
        return this.address;
    }

    public Endpoint withAddress(String address) {
        this.setAddress(address);
        return this;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public Integer getPort() {
        return this.port;
    }

    public Endpoint withPort(Integer port) {
        this.setPort(port);
        return this;
    }

    public void setURL(String uRL) {
        this.uRL = uRL;
    }

    public String getURL() {
        return this.uRL;
    }

    public Endpoint withURL(String uRL) {
        this.setURL(uRL);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAddress() != null) {
            sb.append("Address: ").append(this.getAddress()).append(",");
        }
        if (this.getPort() != null) {
            sb.append("Port: ").append(this.getPort()).append(",");
        }
        if (this.getURL() != null) {
            sb.append("URL: ").append(this.getURL());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Endpoint)) {
            return false;
        }
        Endpoint other = (Endpoint)obj;
        if (other.getAddress() == null ^ this.getAddress() == null) {
            return false;
        }
        if (other.getAddress() != null && !other.getAddress().equals(this.getAddress())) {
            return false;
        }
        if (other.getPort() == null ^ this.getPort() == null) {
            return false;
        }
        if (other.getPort() != null && !other.getPort().equals(this.getPort())) {
            return false;
        }
        if (other.getURL() == null ^ this.getURL() == null) {
            return false;
        }
        return other.getURL() == null || other.getURL().equals(this.getURL());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAddress() == null ? 0 : this.getAddress().hashCode());
        hashCode = 31 * hashCode + (this.getPort() == null ? 0 : this.getPort().hashCode());
        hashCode = 31 * hashCode + (this.getURL() == null ? 0 : this.getURL().hashCode());
        return hashCode;
    }

    public Endpoint clone() {
        try {
            return (Endpoint)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EndpointMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

