/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.deadline.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * The assigned environment when a worker exits a session.
 * </p>
 * 
 * @see <a
 *      href="http://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/AssignedEnvironmentExitSessionActionDefinition"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AssignedEnvironmentExitSessionActionDefinition implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The environment ID of the assigned environment when exiting a session.
     * </p>
     */
    private String environmentId;

    /**
     * <p>
     * The environment ID of the assigned environment when exiting a session.
     * </p>
     * 
     * @param environmentId
     *        The environment ID of the assigned environment when exiting a session.
     */

    public void setEnvironmentId(String environmentId) {
        this.environmentId = environmentId;
    }

    /**
     * <p>
     * The environment ID of the assigned environment when exiting a session.
     * </p>
     * 
     * @return The environment ID of the assigned environment when exiting a session.
     */

    public String getEnvironmentId() {
        return this.environmentId;
    }

    /**
     * <p>
     * The environment ID of the assigned environment when exiting a session.
     * </p>
     * 
     * @param environmentId
     *        The environment ID of the assigned environment when exiting a session.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AssignedEnvironmentExitSessionActionDefinition withEnvironmentId(String environmentId) {
        setEnvironmentId(environmentId);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getEnvironmentId() != null)
            sb.append("EnvironmentId: ").append(getEnvironmentId());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof AssignedEnvironmentExitSessionActionDefinition == false)
            return false;
        AssignedEnvironmentExitSessionActionDefinition other = (AssignedEnvironmentExitSessionActionDefinition) obj;
        if (other.getEnvironmentId() == null ^ this.getEnvironmentId() == null)
            return false;
        if (other.getEnvironmentId() != null && other.getEnvironmentId().equals(this.getEnvironmentId()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getEnvironmentId() == null) ? 0 : getEnvironmentId().hashCode());
        return hashCode;
    }

    @Override
    public AssignedEnvironmentExitSessionActionDefinition clone() {
        try {
            return (AssignedEnvironmentExitSessionActionDefinition) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.deadline.model.transform.AssignedEnvironmentExitSessionActionDefinitionMarshaller.getInstance().marshall(this,
                protocolMarshaller);
    }
}
