/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.deadline.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.deadline.model.FleetAmountCapability;
import com.amazonaws.services.deadline.model.FleetAttributeCapability;
import com.amazonaws.services.deadline.model.transform.FleetCapabilitiesMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class FleetCapabilities
implements Serializable,
Cloneable,
StructuredPojo {
    private List<FleetAmountCapability> amounts;
    private List<FleetAttributeCapability> attributes;

    public List<FleetAmountCapability> getAmounts() {
        return this.amounts;
    }

    public void setAmounts(Collection<FleetAmountCapability> amounts) {
        if (amounts == null) {
            this.amounts = null;
            return;
        }
        this.amounts = new ArrayList<FleetAmountCapability>(amounts);
    }

    public FleetCapabilities withAmounts(FleetAmountCapability ... amounts) {
        if (this.amounts == null) {
            this.setAmounts(new ArrayList<FleetAmountCapability>(amounts.length));
        }
        for (FleetAmountCapability ele : amounts) {
            this.amounts.add(ele);
        }
        return this;
    }

    public FleetCapabilities withAmounts(Collection<FleetAmountCapability> amounts) {
        this.setAmounts(amounts);
        return this;
    }

    public List<FleetAttributeCapability> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Collection<FleetAttributeCapability> attributes) {
        if (attributes == null) {
            this.attributes = null;
            return;
        }
        this.attributes = new ArrayList<FleetAttributeCapability>(attributes);
    }

    public FleetCapabilities withAttributes(FleetAttributeCapability ... attributes) {
        if (this.attributes == null) {
            this.setAttributes(new ArrayList<FleetAttributeCapability>(attributes.length));
        }
        for (FleetAttributeCapability ele : attributes) {
            this.attributes.add(ele);
        }
        return this;
    }

    public FleetCapabilities withAttributes(Collection<FleetAttributeCapability> attributes) {
        this.setAttributes(attributes);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAmounts() != null) {
            sb.append("Amounts: ").append(this.getAmounts()).append(",");
        }
        if (this.getAttributes() != null) {
            sb.append("Attributes: ").append(this.getAttributes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FleetCapabilities)) {
            return false;
        }
        FleetCapabilities other = (FleetCapabilities)obj;
        if (other.getAmounts() == null ^ this.getAmounts() == null) {
            return false;
        }
        if (other.getAmounts() != null && !other.getAmounts().equals(this.getAmounts())) {
            return false;
        }
        if (other.getAttributes() == null ^ this.getAttributes() == null) {
            return false;
        }
        return other.getAttributes() == null || other.getAttributes().equals(this.getAttributes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAmounts() == null ? 0 : this.getAmounts().hashCode());
        hashCode = 31 * hashCode + (this.getAttributes() == null ? 0 : this.getAttributes().hashCode());
        return hashCode;
    }

    public FleetCapabilities clone() {
        try {
            return (FleetCapabilities)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FleetCapabilitiesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

