/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.devicefarm.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.devicefarm.model.DeviceAttribute;
import com.amazonaws.services.devicefarm.model.RuleOperator;
import com.amazonaws.services.devicefarm.model.transform.RuleMarshaller;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;

public class Rule
implements Serializable,
Cloneable,
StructuredPojo {
    private String attribute;
    private String operator;
    private String value;

    public void setAttribute(String attribute) {
        this.attribute = attribute;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public Rule withAttribute(String attribute) {
        this.setAttribute(attribute);
        return this;
    }

    @JsonIgnore
    public void setAttribute(DeviceAttribute attribute) {
        this.attribute = attribute.toString();
    }

    public Rule withAttribute(DeviceAttribute attribute) {
        this.setAttribute(attribute);
        return this;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public String getOperator() {
        return this.operator;
    }

    public Rule withOperator(String operator) {
        this.setOperator(operator);
        return this;
    }

    @JsonIgnore
    public void setOperator(RuleOperator operator) {
        this.operator = operator.toString();
    }

    public Rule withOperator(RuleOperator operator) {
        this.setOperator(operator);
        return this;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public Rule withValue(String value) {
        this.setValue(value);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAttribute() != null) {
            sb.append("Attribute: ").append(this.getAttribute()).append(",");
        }
        if (this.getOperator() != null) {
            sb.append("Operator: ").append(this.getOperator()).append(",");
        }
        if (this.getValue() != null) {
            sb.append("Value: ").append(this.getValue());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Rule)) {
            return false;
        }
        Rule other = (Rule)obj;
        if (other.getAttribute() == null ^ this.getAttribute() == null) {
            return false;
        }
        if (other.getAttribute() != null && !other.getAttribute().equals(this.getAttribute())) {
            return false;
        }
        if (other.getOperator() == null ^ this.getOperator() == null) {
            return false;
        }
        if (other.getOperator() != null && !other.getOperator().equals(this.getOperator())) {
            return false;
        }
        if (other.getValue() == null ^ this.getValue() == null) {
            return false;
        }
        return other.getValue() == null || other.getValue().equals(this.getValue());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAttribute() == null ? 0 : this.getAttribute().hashCode());
        hashCode = 31 * hashCode + (this.getOperator() == null ? 0 : this.getOperator().hashCode());
        hashCode = 31 * hashCode + (this.getValue() == null ? 0 : this.getValue().hashCode());
        return hashCode;
    }

    public Rule clone() {
        try {
            return (Rule)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RuleMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

