/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.devicefarm;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.devicefarm.AWSDeviceFarmAsync;
import com.amazonaws.services.devicefarm.AWSDeviceFarmClient;
import com.amazonaws.services.devicefarm.model.CreateDevicePoolRequest;
import com.amazonaws.services.devicefarm.model.CreateDevicePoolResult;
import com.amazonaws.services.devicefarm.model.CreateProjectRequest;
import com.amazonaws.services.devicefarm.model.CreateProjectResult;
import com.amazonaws.services.devicefarm.model.CreateRemoteAccessSessionRequest;
import com.amazonaws.services.devicefarm.model.CreateRemoteAccessSessionResult;
import com.amazonaws.services.devicefarm.model.CreateUploadRequest;
import com.amazonaws.services.devicefarm.model.CreateUploadResult;
import com.amazonaws.services.devicefarm.model.DeleteDevicePoolRequest;
import com.amazonaws.services.devicefarm.model.DeleteDevicePoolResult;
import com.amazonaws.services.devicefarm.model.DeleteProjectRequest;
import com.amazonaws.services.devicefarm.model.DeleteProjectResult;
import com.amazonaws.services.devicefarm.model.DeleteRemoteAccessSessionRequest;
import com.amazonaws.services.devicefarm.model.DeleteRemoteAccessSessionResult;
import com.amazonaws.services.devicefarm.model.DeleteRunRequest;
import com.amazonaws.services.devicefarm.model.DeleteRunResult;
import com.amazonaws.services.devicefarm.model.DeleteUploadRequest;
import com.amazonaws.services.devicefarm.model.DeleteUploadResult;
import com.amazonaws.services.devicefarm.model.GetAccountSettingsRequest;
import com.amazonaws.services.devicefarm.model.GetAccountSettingsResult;
import com.amazonaws.services.devicefarm.model.GetDevicePoolCompatibilityRequest;
import com.amazonaws.services.devicefarm.model.GetDevicePoolCompatibilityResult;
import com.amazonaws.services.devicefarm.model.GetDevicePoolRequest;
import com.amazonaws.services.devicefarm.model.GetDevicePoolResult;
import com.amazonaws.services.devicefarm.model.GetDeviceRequest;
import com.amazonaws.services.devicefarm.model.GetDeviceResult;
import com.amazonaws.services.devicefarm.model.GetJobRequest;
import com.amazonaws.services.devicefarm.model.GetJobResult;
import com.amazonaws.services.devicefarm.model.GetOfferingStatusRequest;
import com.amazonaws.services.devicefarm.model.GetOfferingStatusResult;
import com.amazonaws.services.devicefarm.model.GetProjectRequest;
import com.amazonaws.services.devicefarm.model.GetProjectResult;
import com.amazonaws.services.devicefarm.model.GetRemoteAccessSessionRequest;
import com.amazonaws.services.devicefarm.model.GetRemoteAccessSessionResult;
import com.amazonaws.services.devicefarm.model.GetRunRequest;
import com.amazonaws.services.devicefarm.model.GetRunResult;
import com.amazonaws.services.devicefarm.model.GetSuiteRequest;
import com.amazonaws.services.devicefarm.model.GetSuiteResult;
import com.amazonaws.services.devicefarm.model.GetTestRequest;
import com.amazonaws.services.devicefarm.model.GetTestResult;
import com.amazonaws.services.devicefarm.model.GetUploadRequest;
import com.amazonaws.services.devicefarm.model.GetUploadResult;
import com.amazonaws.services.devicefarm.model.InstallToRemoteAccessSessionRequest;
import com.amazonaws.services.devicefarm.model.InstallToRemoteAccessSessionResult;
import com.amazonaws.services.devicefarm.model.ListArtifactsRequest;
import com.amazonaws.services.devicefarm.model.ListArtifactsResult;
import com.amazonaws.services.devicefarm.model.ListDevicePoolsRequest;
import com.amazonaws.services.devicefarm.model.ListDevicePoolsResult;
import com.amazonaws.services.devicefarm.model.ListDevicesRequest;
import com.amazonaws.services.devicefarm.model.ListDevicesResult;
import com.amazonaws.services.devicefarm.model.ListJobsRequest;
import com.amazonaws.services.devicefarm.model.ListJobsResult;
import com.amazonaws.services.devicefarm.model.ListOfferingTransactionsRequest;
import com.amazonaws.services.devicefarm.model.ListOfferingTransactionsResult;
import com.amazonaws.services.devicefarm.model.ListOfferingsRequest;
import com.amazonaws.services.devicefarm.model.ListOfferingsResult;
import com.amazonaws.services.devicefarm.model.ListProjectsRequest;
import com.amazonaws.services.devicefarm.model.ListProjectsResult;
import com.amazonaws.services.devicefarm.model.ListRemoteAccessSessionsRequest;
import com.amazonaws.services.devicefarm.model.ListRemoteAccessSessionsResult;
import com.amazonaws.services.devicefarm.model.ListRunsRequest;
import com.amazonaws.services.devicefarm.model.ListRunsResult;
import com.amazonaws.services.devicefarm.model.ListSamplesRequest;
import com.amazonaws.services.devicefarm.model.ListSamplesResult;
import com.amazonaws.services.devicefarm.model.ListSuitesRequest;
import com.amazonaws.services.devicefarm.model.ListSuitesResult;
import com.amazonaws.services.devicefarm.model.ListTestsRequest;
import com.amazonaws.services.devicefarm.model.ListTestsResult;
import com.amazonaws.services.devicefarm.model.ListUniqueProblemsRequest;
import com.amazonaws.services.devicefarm.model.ListUniqueProblemsResult;
import com.amazonaws.services.devicefarm.model.ListUploadsRequest;
import com.amazonaws.services.devicefarm.model.ListUploadsResult;
import com.amazonaws.services.devicefarm.model.PurchaseOfferingRequest;
import com.amazonaws.services.devicefarm.model.PurchaseOfferingResult;
import com.amazonaws.services.devicefarm.model.RenewOfferingRequest;
import com.amazonaws.services.devicefarm.model.RenewOfferingResult;
import com.amazonaws.services.devicefarm.model.ScheduleRunRequest;
import com.amazonaws.services.devicefarm.model.ScheduleRunResult;
import com.amazonaws.services.devicefarm.model.StopRemoteAccessSessionRequest;
import com.amazonaws.services.devicefarm.model.StopRemoteAccessSessionResult;
import com.amazonaws.services.devicefarm.model.StopRunRequest;
import com.amazonaws.services.devicefarm.model.StopRunResult;
import com.amazonaws.services.devicefarm.model.UpdateDevicePoolRequest;
import com.amazonaws.services.devicefarm.model.UpdateDevicePoolResult;
import com.amazonaws.services.devicefarm.model.UpdateProjectRequest;
import com.amazonaws.services.devicefarm.model.UpdateProjectResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSDeviceFarmAsyncClient
extends AWSDeviceFarmClient
implements AWSDeviceFarmAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public AWSDeviceFarmAsyncClient() {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain());
    }

    public AWSDeviceFarmAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AWSDeviceFarmAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AWSDeviceFarmAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    public AWSDeviceFarmAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AWSDeviceFarmAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AWSDeviceFarmAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AWSDeviceFarmAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    public AWSDeviceFarmAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    AWSDeviceFarmAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super((AwsSyncClientParams)asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateDevicePoolResult> createDevicePoolAsync(CreateDevicePoolRequest request) {
        return this.createDevicePoolAsync(request, null);
    }

    @Override
    public Future<CreateDevicePoolResult> createDevicePoolAsync(final CreateDevicePoolRequest request, final AsyncHandler<CreateDevicePoolRequest, CreateDevicePoolResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateDevicePoolResult>(){

            @Override
            public CreateDevicePoolResult call() throws Exception {
                CreateDevicePoolResult result;
                try {
                    result = AWSDeviceFarmAsyncClient.this.createDevicePool(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateProjectResult> createProjectAsync(CreateProjectRequest request) {
        return this.createProjectAsync(request, null);
    }

    @Override
    public Future<CreateProjectResult> createProjectAsync(final CreateProjectRequest request, final AsyncHandler<CreateProjectRequest, CreateProjectResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateProjectResult>(){

            @Override
            public CreateProjectResult call() throws Exception {
                CreateProjectResult result;
                try {
                    result = AWSDeviceFarmAsyncClient.this.createProject(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateRemoteAccessSessionResult> createRemoteAccessSessionAsync(CreateRemoteAccessSessionRequest request) {
        return this.createRemoteAccessSessionAsync(request, null);
    }

    @Override
    public Future<CreateRemoteAccessSessionResult> createRemoteAccessSessionAsync(final CreateRemoteAccessSessionRequest request, final AsyncHandler<CreateRemoteAccessSessionRequest, CreateRemoteAccessSessionResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateRemoteAccessSessionResult>(){

            @Override
            public CreateRemoteAccessSessionResult call() throws Exception {
                CreateRemoteAccessSessionResult result;
                try {
                    result = AWSDeviceFarmAsyncClient.this.createRemoteAccessSession(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateUploadResult> createUploadAsync(CreateUploadRequest request) {
        return this.createUploadAsync(request, null);
    }

    @Override
    public Future<CreateUploadResult> createUploadAsync(final CreateUploadRequest request, final AsyncHandler<CreateUploadRequest, CreateUploadResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateUploadResult>(){

            @Override
            public CreateUploadResult call() throws Exception {
                CreateUploadResult result;
                try {
                    result = AWSDeviceFarmAsyncClient.this.createUpload(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteDevicePoolResult> deleteDevicePoolAsync(DeleteDevicePoolRequest request) {
        return this.deleteDevicePoolAsync(request, null);
    }

    @Override
    public Future<DeleteDevicePoolResult> deleteDevicePoolAsync(final DeleteDevicePoolRequest request, final AsyncHandler<DeleteDevicePoolRequest, DeleteDevicePoolResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteDevicePoolResult>(){

            @Override
            public DeleteDevicePoolResult call() throws Exception {
                DeleteDevicePoolResult result;
                try {
                    result = AWSDeviceFarmAsyncClient.this.deleteDevicePool(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteProjectResult> deleteProjectAsync(DeleteProjectRequest request) {
        return this.deleteProjectAsync(request, null);
    }

    @Override
    public Future<DeleteProjectResult> deleteProjectAsync(final DeleteProjectRequest request, final AsyncHandler<DeleteProjectRequest, DeleteProjectResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteProjectResult>(){

            @Override
            public DeleteProjectResult call() throws Exception {
                DeleteProjectResult result;
                try {
                    result = AWSDeviceFarmAsyncClient.this.deleteProject(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteRemoteAccessSessionResult> deleteRemoteAccessSessionAsync(DeleteRemoteAccessSessionRequest request) {
        return this.deleteRemoteAccessSessionAsync(request, null);
    }

    @Override
    public Future<DeleteRemoteAccessSessionResult> deleteRemoteAccessSessionAsync(final DeleteRemoteAccessSessionRequest request, final AsyncHandler<DeleteRemoteAccessSessionRequest, DeleteRemoteAccessSessionResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteRemoteAccessSessionResult>(){

            @Override
            public DeleteRemoteAccessSessionResult call() throws Exception {
                DeleteRemoteAccessSessionResult result;
                try {
                    result = AWSDeviceFarmAsyncClient.this.deleteRemoteAccessSession(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteRunResult> deleteRunAsync(DeleteRunRequest request) {
        return this.deleteRunAsync(request, null);
    }

    @Override
    public Future<DeleteRunResult> deleteRunAsync(final DeleteRunRequest request, final AsyncHandler<DeleteRunRequest, DeleteRunResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteRunResult>(){

            @Override
            public DeleteRunResult call() throws Exception {
                DeleteRunResult result;
                try {
                    result = AWSDeviceFarmAsyncClient.this.deleteRun(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteUploadResult> deleteUploadAsync(DeleteUploadRequest request) {
        return this.deleteUploadAsync(request, null);
    }

    @Override
    public Future<DeleteUploadResult> deleteUploadAsync(final DeleteUploadRequest request, final AsyncHandler<DeleteUploadRequest, DeleteUploadResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteUploadResult>(){

            @Override
            public DeleteUploadResult call() throws Exception {
                DeleteUploadResult result;
                try {
                    result = AWSDeviceFarmAsyncClient.this.deleteUpload(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetAccountSettingsResult> getAccountSettingsAsync(GetAccountSettingsRequest request) {
        return this.getAccountSettingsAsync(request, null);
    }

    @Override
    public Future<GetAccountSettingsResult> getAccountSettingsAsync(final GetAccountSettingsRequest request, final AsyncHandler<GetAccountSettingsRequest, GetAccountSettingsResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetAccountSettingsResult>(){

            @Override
            public GetAccountSettingsResult call() throws Exception {
                GetAccountSettingsResult result;
                try {
                    result = AWSDeviceFarmAsyncClient.this.getAccountSettings(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetDeviceResult> getDeviceAsync(GetDeviceRequest request) {
        return this.getDeviceAsync(request, null);
    }

    @Override
    public Future<GetDeviceResult> getDeviceAsync(final GetDeviceRequest request, final AsyncHandler<GetDeviceRequest, GetDeviceResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetDeviceResult>(){

            @Override
            public GetDeviceResult call() throws Exception {
                GetDeviceResult result;
                try {
                    result = AWSDeviceFarmAsyncClient.this.getDevice(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetDevicePoolResult> getDevicePoolAsync(GetDevicePoolRequest request) {
        return this.getDevicePoolAsync(request, null);
    }

    @Override
    public Future<GetDevicePoolResult> getDevicePoolAsync(final GetDevicePoolRequest request, final AsyncHandler<GetDevicePoolRequest, GetDevicePoolResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetDevicePoolResult>(){

            @Override
            public GetDevicePoolResult call() throws Exception {
                GetDevicePoolResult result;
                try {
                    result = AWSDeviceFarmAsyncClient.this.getDevicePool(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetDevicePoolCompatibilityResult> getDevicePoolCompatibilityAsync(GetDevicePoolCompatibilityRequest request) {
        return this.getDevicePoolCompatibilityAsync(request, null);
    }

    @Override
    public Future<GetDevicePoolCompatibilityResult> getDevicePoolCompatibilityAsync(final GetDevicePoolCompatibilityRequest request, final AsyncHandler<GetDevicePoolCompatibilityRequest, GetDevicePoolCompatibilityResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetDevicePoolCompatibilityResult>(){

            @Override
            public GetDevicePoolCompatibilityResult call() throws Exception {
                GetDevicePoolCompatibilityResult result;
                try {
                    result = AWSDeviceFarmAsyncClient.this.getDevicePoolCompatibility(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetJobResult> getJobAsync(GetJobRequest request) {
        return this.getJobAsync(request, null);
    }

    @Override
    public Future<GetJobResult> getJobAsync(final GetJobRequest request, final AsyncHandler<GetJobRequest, GetJobResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetJobResult>(){

            @Override
            public GetJobResult call() throws Exception {
                GetJobResult result;
                try {
                    result = AWSDeviceFarmAsyncClient.this.getJob(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetOfferingStatusResult> getOfferingStatusAsync(GetOfferingStatusRequest request) {
        return this.getOfferingStatusAsync(request, null);
    }

    @Override
    public Future<GetOfferingStatusResult> getOfferingStatusAsync(final GetOfferingStatusRequest request, final AsyncHandler<GetOfferingStatusRequest, GetOfferingStatusResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetOfferingStatusResult>(){

            @Override
            public GetOfferingStatusResult call() throws Exception {
                GetOfferingStatusResult result;
                try {
                    result = AWSDeviceFarmAsyncClient.this.getOfferingStatus(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetProjectResult> getProjectAsync(GetProjectRequest request) {
        return this.getProjectAsync(request, null);
    }

    @Override
    public Future<GetProjectResult> getProjectAsync(final GetProjectRequest request, final AsyncHandler<GetProjectRequest, GetProjectResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetProjectResult>(){

            @Override
            public GetProjectResult call() throws Exception {
                GetProjectResult result;
                try {
                    result = AWSDeviceFarmAsyncClient.this.getProject(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetRemoteAccessSessionResult> getRemoteAccessSessionAsync(GetRemoteAccessSessionRequest request) {
        return this.getRemoteAccessSessionAsync(request, null);
    }

    @Override
    public Future<GetRemoteAccessSessionResult> getRemoteAccessSessionAsync(final GetRemoteAccessSessionRequest request, final AsyncHandler<GetRemoteAccessSessionRequest, GetRemoteAccessSessionResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetRemoteAccessSessionResult>(){

            @Override
            public GetRemoteAccessSessionResult call() throws Exception {
                GetRemoteAccessSessionResult result;
                try {
                    result = AWSDeviceFarmAsyncClient.this.getRemoteAccessSession(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetRunResult> getRunAsync(GetRunRequest request) {
        return this.getRunAsync(request, null);
    }

    @Override
    public Future<GetRunResult> getRunAsync(final GetRunRequest request, final AsyncHandler<GetRunRequest, GetRunResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetRunResult>(){

            @Override
            public GetRunResult call() throws Exception {
                GetRunResult result;
                try {
                    result = AWSDeviceFarmAsyncClient.this.getRun(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetSuiteResult> getSuiteAsync(GetSuiteRequest request) {
        return this.getSuiteAsync(request, null);
    }

    @Override
    public Future<GetSuiteResult> getSuiteAsync(final GetSuiteRequest request, final AsyncHandler<GetSuiteRequest, GetSuiteResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetSuiteResult>(){

            @Override
            public GetSuiteResult call() throws Exception {
                GetSuiteResult result;
                try {
                    result = AWSDeviceFarmAsyncClient.this.getSuite(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetTestResult> getTestAsync(GetTestRequest request) {
        return this.getTestAsync(request, null);
    }

    @Override
    public Future<GetTestResult> getTestAsync(final GetTestRequest request, final AsyncHandler<GetTestRequest, GetTestResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetTestResult>(){

            @Override
            public GetTestResult call() throws Exception {
                GetTestResult result;
                try {
                    result = AWSDeviceFarmAsyncClient.this.getTest(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetUploadResult> getUploadAsync(GetUploadRequest request) {
        return this.getUploadAsync(request, null);
    }

    @Override
    public Future<GetUploadResult> getUploadAsync(final GetUploadRequest request, final AsyncHandler<GetUploadRequest, GetUploadResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetUploadResult>(){

            @Override
            public GetUploadResult call() throws Exception {
                GetUploadResult result;
                try {
                    result = AWSDeviceFarmAsyncClient.this.getUpload(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<InstallToRemoteAccessSessionResult> installToRemoteAccessSessionAsync(InstallToRemoteAccessSessionRequest request) {
        return this.installToRemoteAccessSessionAsync(request, null);
    }

    @Override
    public Future<InstallToRemoteAccessSessionResult> installToRemoteAccessSessionAsync(final InstallToRemoteAccessSessionRequest request, final AsyncHandler<InstallToRemoteAccessSessionRequest, InstallToRemoteAccessSessionResult> asyncHandler) {
        return this.executorService.submit(new Callable<InstallToRemoteAccessSessionResult>(){

            @Override
            public InstallToRemoteAccessSessionResult call() throws Exception {
                InstallToRemoteAccessSessionResult result;
                try {
                    result = AWSDeviceFarmAsyncClient.this.installToRemoteAccessSession(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListArtifactsResult> listArtifactsAsync(ListArtifactsRequest request) {
        return this.listArtifactsAsync(request, null);
    }

    @Override
    public Future<ListArtifactsResult> listArtifactsAsync(final ListArtifactsRequest request, final AsyncHandler<ListArtifactsRequest, ListArtifactsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListArtifactsResult>(){

            @Override
            public ListArtifactsResult call() throws Exception {
                ListArtifactsResult result;
                try {
                    result = AWSDeviceFarmAsyncClient.this.listArtifacts(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListDevicePoolsResult> listDevicePoolsAsync(ListDevicePoolsRequest request) {
        return this.listDevicePoolsAsync(request, null);
    }

    @Override
    public Future<ListDevicePoolsResult> listDevicePoolsAsync(final ListDevicePoolsRequest request, final AsyncHandler<ListDevicePoolsRequest, ListDevicePoolsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListDevicePoolsResult>(){

            @Override
            public ListDevicePoolsResult call() throws Exception {
                ListDevicePoolsResult result;
                try {
                    result = AWSDeviceFarmAsyncClient.this.listDevicePools(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListDevicesResult> listDevicesAsync(ListDevicesRequest request) {
        return this.listDevicesAsync(request, null);
    }

    @Override
    public Future<ListDevicesResult> listDevicesAsync(final ListDevicesRequest request, final AsyncHandler<ListDevicesRequest, ListDevicesResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListDevicesResult>(){

            @Override
            public ListDevicesResult call() throws Exception {
                ListDevicesResult result;
                try {
                    result = AWSDeviceFarmAsyncClient.this.listDevices(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListJobsResult> listJobsAsync(ListJobsRequest request) {
        return this.listJobsAsync(request, null);
    }

    @Override
    public Future<ListJobsResult> listJobsAsync(final ListJobsRequest request, final AsyncHandler<ListJobsRequest, ListJobsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListJobsResult>(){

            @Override
            public ListJobsResult call() throws Exception {
                ListJobsResult result;
                try {
                    result = AWSDeviceFarmAsyncClient.this.listJobs(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListOfferingTransactionsResult> listOfferingTransactionsAsync(ListOfferingTransactionsRequest request) {
        return this.listOfferingTransactionsAsync(request, null);
    }

    @Override
    public Future<ListOfferingTransactionsResult> listOfferingTransactionsAsync(final ListOfferingTransactionsRequest request, final AsyncHandler<ListOfferingTransactionsRequest, ListOfferingTransactionsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListOfferingTransactionsResult>(){

            @Override
            public ListOfferingTransactionsResult call() throws Exception {
                ListOfferingTransactionsResult result;
                try {
                    result = AWSDeviceFarmAsyncClient.this.listOfferingTransactions(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListOfferingsResult> listOfferingsAsync(ListOfferingsRequest request) {
        return this.listOfferingsAsync(request, null);
    }

    @Override
    public Future<ListOfferingsResult> listOfferingsAsync(final ListOfferingsRequest request, final AsyncHandler<ListOfferingsRequest, ListOfferingsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListOfferingsResult>(){

            @Override
            public ListOfferingsResult call() throws Exception {
                ListOfferingsResult result;
                try {
                    result = AWSDeviceFarmAsyncClient.this.listOfferings(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListProjectsResult> listProjectsAsync(ListProjectsRequest request) {
        return this.listProjectsAsync(request, null);
    }

    @Override
    public Future<ListProjectsResult> listProjectsAsync(final ListProjectsRequest request, final AsyncHandler<ListProjectsRequest, ListProjectsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListProjectsResult>(){

            @Override
            public ListProjectsResult call() throws Exception {
                ListProjectsResult result;
                try {
                    result = AWSDeviceFarmAsyncClient.this.listProjects(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListRemoteAccessSessionsResult> listRemoteAccessSessionsAsync(ListRemoteAccessSessionsRequest request) {
        return this.listRemoteAccessSessionsAsync(request, null);
    }

    @Override
    public Future<ListRemoteAccessSessionsResult> listRemoteAccessSessionsAsync(final ListRemoteAccessSessionsRequest request, final AsyncHandler<ListRemoteAccessSessionsRequest, ListRemoteAccessSessionsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListRemoteAccessSessionsResult>(){

            @Override
            public ListRemoteAccessSessionsResult call() throws Exception {
                ListRemoteAccessSessionsResult result;
                try {
                    result = AWSDeviceFarmAsyncClient.this.listRemoteAccessSessions(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListRunsResult> listRunsAsync(ListRunsRequest request) {
        return this.listRunsAsync(request, null);
    }

    @Override
    public Future<ListRunsResult> listRunsAsync(final ListRunsRequest request, final AsyncHandler<ListRunsRequest, ListRunsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListRunsResult>(){

            @Override
            public ListRunsResult call() throws Exception {
                ListRunsResult result;
                try {
                    result = AWSDeviceFarmAsyncClient.this.listRuns(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListSamplesResult> listSamplesAsync(ListSamplesRequest request) {
        return this.listSamplesAsync(request, null);
    }

    @Override
    public Future<ListSamplesResult> listSamplesAsync(final ListSamplesRequest request, final AsyncHandler<ListSamplesRequest, ListSamplesResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListSamplesResult>(){

            @Override
            public ListSamplesResult call() throws Exception {
                ListSamplesResult result;
                try {
                    result = AWSDeviceFarmAsyncClient.this.listSamples(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListSuitesResult> listSuitesAsync(ListSuitesRequest request) {
        return this.listSuitesAsync(request, null);
    }

    @Override
    public Future<ListSuitesResult> listSuitesAsync(final ListSuitesRequest request, final AsyncHandler<ListSuitesRequest, ListSuitesResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListSuitesResult>(){

            @Override
            public ListSuitesResult call() throws Exception {
                ListSuitesResult result;
                try {
                    result = AWSDeviceFarmAsyncClient.this.listSuites(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTestsResult> listTestsAsync(ListTestsRequest request) {
        return this.listTestsAsync(request, null);
    }

    @Override
    public Future<ListTestsResult> listTestsAsync(final ListTestsRequest request, final AsyncHandler<ListTestsRequest, ListTestsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListTestsResult>(){

            @Override
            public ListTestsResult call() throws Exception {
                ListTestsResult result;
                try {
                    result = AWSDeviceFarmAsyncClient.this.listTests(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListUniqueProblemsResult> listUniqueProblemsAsync(ListUniqueProblemsRequest request) {
        return this.listUniqueProblemsAsync(request, null);
    }

    @Override
    public Future<ListUniqueProblemsResult> listUniqueProblemsAsync(final ListUniqueProblemsRequest request, final AsyncHandler<ListUniqueProblemsRequest, ListUniqueProblemsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListUniqueProblemsResult>(){

            @Override
            public ListUniqueProblemsResult call() throws Exception {
                ListUniqueProblemsResult result;
                try {
                    result = AWSDeviceFarmAsyncClient.this.listUniqueProblems(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListUploadsResult> listUploadsAsync(ListUploadsRequest request) {
        return this.listUploadsAsync(request, null);
    }

    @Override
    public Future<ListUploadsResult> listUploadsAsync(final ListUploadsRequest request, final AsyncHandler<ListUploadsRequest, ListUploadsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListUploadsResult>(){

            @Override
            public ListUploadsResult call() throws Exception {
                ListUploadsResult result;
                try {
                    result = AWSDeviceFarmAsyncClient.this.listUploads(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PurchaseOfferingResult> purchaseOfferingAsync(PurchaseOfferingRequest request) {
        return this.purchaseOfferingAsync(request, null);
    }

    @Override
    public Future<PurchaseOfferingResult> purchaseOfferingAsync(final PurchaseOfferingRequest request, final AsyncHandler<PurchaseOfferingRequest, PurchaseOfferingResult> asyncHandler) {
        return this.executorService.submit(new Callable<PurchaseOfferingResult>(){

            @Override
            public PurchaseOfferingResult call() throws Exception {
                PurchaseOfferingResult result;
                try {
                    result = AWSDeviceFarmAsyncClient.this.purchaseOffering(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RenewOfferingResult> renewOfferingAsync(RenewOfferingRequest request) {
        return this.renewOfferingAsync(request, null);
    }

    @Override
    public Future<RenewOfferingResult> renewOfferingAsync(final RenewOfferingRequest request, final AsyncHandler<RenewOfferingRequest, RenewOfferingResult> asyncHandler) {
        return this.executorService.submit(new Callable<RenewOfferingResult>(){

            @Override
            public RenewOfferingResult call() throws Exception {
                RenewOfferingResult result;
                try {
                    result = AWSDeviceFarmAsyncClient.this.renewOffering(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ScheduleRunResult> scheduleRunAsync(ScheduleRunRequest request) {
        return this.scheduleRunAsync(request, null);
    }

    @Override
    public Future<ScheduleRunResult> scheduleRunAsync(final ScheduleRunRequest request, final AsyncHandler<ScheduleRunRequest, ScheduleRunResult> asyncHandler) {
        return this.executorService.submit(new Callable<ScheduleRunResult>(){

            @Override
            public ScheduleRunResult call() throws Exception {
                ScheduleRunResult result;
                try {
                    result = AWSDeviceFarmAsyncClient.this.scheduleRun(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StopRemoteAccessSessionResult> stopRemoteAccessSessionAsync(StopRemoteAccessSessionRequest request) {
        return this.stopRemoteAccessSessionAsync(request, null);
    }

    @Override
    public Future<StopRemoteAccessSessionResult> stopRemoteAccessSessionAsync(final StopRemoteAccessSessionRequest request, final AsyncHandler<StopRemoteAccessSessionRequest, StopRemoteAccessSessionResult> asyncHandler) {
        return this.executorService.submit(new Callable<StopRemoteAccessSessionResult>(){

            @Override
            public StopRemoteAccessSessionResult call() throws Exception {
                StopRemoteAccessSessionResult result;
                try {
                    result = AWSDeviceFarmAsyncClient.this.stopRemoteAccessSession(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StopRunResult> stopRunAsync(StopRunRequest request) {
        return this.stopRunAsync(request, null);
    }

    @Override
    public Future<StopRunResult> stopRunAsync(final StopRunRequest request, final AsyncHandler<StopRunRequest, StopRunResult> asyncHandler) {
        return this.executorService.submit(new Callable<StopRunResult>(){

            @Override
            public StopRunResult call() throws Exception {
                StopRunResult result;
                try {
                    result = AWSDeviceFarmAsyncClient.this.stopRun(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateDevicePoolResult> updateDevicePoolAsync(UpdateDevicePoolRequest request) {
        return this.updateDevicePoolAsync(request, null);
    }

    @Override
    public Future<UpdateDevicePoolResult> updateDevicePoolAsync(final UpdateDevicePoolRequest request, final AsyncHandler<UpdateDevicePoolRequest, UpdateDevicePoolResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateDevicePoolResult>(){

            @Override
            public UpdateDevicePoolResult call() throws Exception {
                UpdateDevicePoolResult result;
                try {
                    result = AWSDeviceFarmAsyncClient.this.updateDevicePool(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateProjectResult> updateProjectAsync(UpdateProjectRequest request) {
        return this.updateProjectAsync(request, null);
    }

    @Override
    public Future<UpdateProjectResult> updateProjectAsync(final UpdateProjectRequest request, final AsyncHandler<UpdateProjectRequest, UpdateProjectResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateProjectResult>(){

            @Override
            public UpdateProjectResult call() throws Exception {
                UpdateProjectResult result;
                try {
                    result = AWSDeviceFarmAsyncClient.this.updateProject(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

