/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.devicefarm.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.devicefarm.model.Suite;
import com.amazonaws.services.devicefarm.model.transform.CountersJsonMarshaller;
import com.amazonaws.services.devicefarm.model.transform.DeviceMinutesJsonMarshaller;

public class SuiteJsonMarshaller {
    private static SuiteJsonMarshaller instance;

    public void marshall(Suite suite, StructuredJsonGenerator jsonGenerator) {
        if (suite == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (suite.getArn() != null) {
                jsonGenerator.writeFieldName("arn").writeValue(suite.getArn());
            }
            if (suite.getName() != null) {
                jsonGenerator.writeFieldName("name").writeValue(suite.getName());
            }
            if (suite.getType() != null) {
                jsonGenerator.writeFieldName("type").writeValue(suite.getType());
            }
            if (suite.getCreated() != null) {
                jsonGenerator.writeFieldName("created").writeValue(suite.getCreated());
            }
            if (suite.getStatus() != null) {
                jsonGenerator.writeFieldName("status").writeValue(suite.getStatus());
            }
            if (suite.getResult() != null) {
                jsonGenerator.writeFieldName("result").writeValue(suite.getResult());
            }
            if (suite.getStarted() != null) {
                jsonGenerator.writeFieldName("started").writeValue(suite.getStarted());
            }
            if (suite.getStopped() != null) {
                jsonGenerator.writeFieldName("stopped").writeValue(suite.getStopped());
            }
            if (suite.getCounters() != null) {
                jsonGenerator.writeFieldName("counters");
                CountersJsonMarshaller.getInstance().marshall(suite.getCounters(), jsonGenerator);
            }
            if (suite.getMessage() != null) {
                jsonGenerator.writeFieldName("message").writeValue(suite.getMessage());
            }
            if (suite.getDeviceMinutes() != null) {
                jsonGenerator.writeFieldName("deviceMinutes");
                DeviceMinutesJsonMarshaller.getInstance().marshall(suite.getDeviceMinutes(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static SuiteJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new SuiteJsonMarshaller();
        }
        return instance;
    }
}

