/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.devicefarm.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * <p>
 * Represents a request to the get device pool compatibility operation.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetDevicePoolCompatibility"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class GetDevicePoolCompatibilityRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * The device pool's ARN.
     * </p>
     */
    private String devicePoolArn;
    /**
     * <p>
     * The ARN of the app that is associated with the specified device pool.
     * </p>
     */
    private String appArn;
    /**
     * <p>
     * The test type for the specified device pool.
     * </p>
     * <p>
     * Allowed values include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * BUILTIN_FUZZ.
     * </p>
     * </li>
     * <li>
     * <p>
     * BUILTIN_EXPLORER. For Android, an app explorer that traverses an Android app, interacting with it and capturing
     * screenshots at the same time.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_JAVA_JUNIT.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_JAVA_TESTNG.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_PYTHON.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_NODE.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_RUBY.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_JAVA_JUNIT.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_JAVA_TESTNG.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_PYTHON.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_NODE.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_RUBY.
     * </p>
     * </li>
     * <li>
     * <p>
     * CALABASH.
     * </p>
     * </li>
     * <li>
     * <p>
     * INSTRUMENTATION.
     * </p>
     * </li>
     * <li>
     * <p>
     * UIAUTOMATION.
     * </p>
     * </li>
     * <li>
     * <p>
     * UIAUTOMATOR.
     * </p>
     * </li>
     * <li>
     * <p>
     * XCTEST.
     * </p>
     * </li>
     * <li>
     * <p>
     * XCTEST_UI.
     * </p>
     * </li>
     * </ul>
     */
    private String testType;
    /**
     * <p>
     * Information about the uploaded test to be run against the device pool.
     * </p>
     */
    private ScheduleRunTest test;
    /**
     * <p>
     * An object that contains information about the settings for a run.
     * </p>
     */
    private ScheduleRunConfiguration configuration;

    /**
     * <p>
     * The device pool's ARN.
     * </p>
     * 
     * @param devicePoolArn
     *        The device pool's ARN.
     */

    public void setDevicePoolArn(String devicePoolArn) {
        this.devicePoolArn = devicePoolArn;
    }

    /**
     * <p>
     * The device pool's ARN.
     * </p>
     * 
     * @return The device pool's ARN.
     */

    public String getDevicePoolArn() {
        return this.devicePoolArn;
    }

    /**
     * <p>
     * The device pool's ARN.
     * </p>
     * 
     * @param devicePoolArn
     *        The device pool's ARN.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetDevicePoolCompatibilityRequest withDevicePoolArn(String devicePoolArn) {
        setDevicePoolArn(devicePoolArn);
        return this;
    }

    /**
     * <p>
     * The ARN of the app that is associated with the specified device pool.
     * </p>
     * 
     * @param appArn
     *        The ARN of the app that is associated with the specified device pool.
     */

    public void setAppArn(String appArn) {
        this.appArn = appArn;
    }

    /**
     * <p>
     * The ARN of the app that is associated with the specified device pool.
     * </p>
     * 
     * @return The ARN of the app that is associated with the specified device pool.
     */

    public String getAppArn() {
        return this.appArn;
    }

    /**
     * <p>
     * The ARN of the app that is associated with the specified device pool.
     * </p>
     * 
     * @param appArn
     *        The ARN of the app that is associated with the specified device pool.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetDevicePoolCompatibilityRequest withAppArn(String appArn) {
        setAppArn(appArn);
        return this;
    }

    /**
     * <p>
     * The test type for the specified device pool.
     * </p>
     * <p>
     * Allowed values include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * BUILTIN_FUZZ.
     * </p>
     * </li>
     * <li>
     * <p>
     * BUILTIN_EXPLORER. For Android, an app explorer that traverses an Android app, interacting with it and capturing
     * screenshots at the same time.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_JAVA_JUNIT.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_JAVA_TESTNG.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_PYTHON.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_NODE.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_RUBY.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_JAVA_JUNIT.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_JAVA_TESTNG.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_PYTHON.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_NODE.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_RUBY.
     * </p>
     * </li>
     * <li>
     * <p>
     * CALABASH.
     * </p>
     * </li>
     * <li>
     * <p>
     * INSTRUMENTATION.
     * </p>
     * </li>
     * <li>
     * <p>
     * UIAUTOMATION.
     * </p>
     * </li>
     * <li>
     * <p>
     * UIAUTOMATOR.
     * </p>
     * </li>
     * <li>
     * <p>
     * XCTEST.
     * </p>
     * </li>
     * <li>
     * <p>
     * XCTEST_UI.
     * </p>
     * </li>
     * </ul>
     * 
     * @param testType
     *        The test type for the specified device pool.</p>
     *        <p>
     *        Allowed values include the following:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        BUILTIN_FUZZ.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        BUILTIN_EXPLORER. For Android, an app explorer that traverses an Android app, interacting with it and
     *        capturing screenshots at the same time.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        APPIUM_JAVA_JUNIT.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        APPIUM_JAVA_TESTNG.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        APPIUM_PYTHON.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        APPIUM_NODE.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        APPIUM_RUBY.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        APPIUM_WEB_JAVA_JUNIT.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        APPIUM_WEB_JAVA_TESTNG.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        APPIUM_WEB_PYTHON.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        APPIUM_WEB_NODE.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        APPIUM_WEB_RUBY.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        CALABASH.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        INSTRUMENTATION.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        UIAUTOMATION.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        UIAUTOMATOR.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        XCTEST.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        XCTEST_UI.
     *        </p>
     *        </li>
     * @see TestType
     */

    public void setTestType(String testType) {
        this.testType = testType;
    }

    /**
     * <p>
     * The test type for the specified device pool.
     * </p>
     * <p>
     * Allowed values include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * BUILTIN_FUZZ.
     * </p>
     * </li>
     * <li>
     * <p>
     * BUILTIN_EXPLORER. For Android, an app explorer that traverses an Android app, interacting with it and capturing
     * screenshots at the same time.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_JAVA_JUNIT.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_JAVA_TESTNG.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_PYTHON.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_NODE.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_RUBY.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_JAVA_JUNIT.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_JAVA_TESTNG.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_PYTHON.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_NODE.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_RUBY.
     * </p>
     * </li>
     * <li>
     * <p>
     * CALABASH.
     * </p>
     * </li>
     * <li>
     * <p>
     * INSTRUMENTATION.
     * </p>
     * </li>
     * <li>
     * <p>
     * UIAUTOMATION.
     * </p>
     * </li>
     * <li>
     * <p>
     * UIAUTOMATOR.
     * </p>
     * </li>
     * <li>
     * <p>
     * XCTEST.
     * </p>
     * </li>
     * <li>
     * <p>
     * XCTEST_UI.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The test type for the specified device pool.</p>
     *         <p>
     *         Allowed values include the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         BUILTIN_FUZZ.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         BUILTIN_EXPLORER. For Android, an app explorer that traverses an Android app, interacting with it and
     *         capturing screenshots at the same time.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_JAVA_JUNIT.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_JAVA_TESTNG.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_PYTHON.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_NODE.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_RUBY.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_JAVA_JUNIT.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_JAVA_TESTNG.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_PYTHON.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_NODE.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_RUBY.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CALABASH.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INSTRUMENTATION.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UIAUTOMATION.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UIAUTOMATOR.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         XCTEST.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         XCTEST_UI.
     *         </p>
     *         </li>
     * @see TestType
     */

    public String getTestType() {
        return this.testType;
    }

    /**
     * <p>
     * The test type for the specified device pool.
     * </p>
     * <p>
     * Allowed values include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * BUILTIN_FUZZ.
     * </p>
     * </li>
     * <li>
     * <p>
     * BUILTIN_EXPLORER. For Android, an app explorer that traverses an Android app, interacting with it and capturing
     * screenshots at the same time.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_JAVA_JUNIT.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_JAVA_TESTNG.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_PYTHON.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_NODE.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_RUBY.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_JAVA_JUNIT.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_JAVA_TESTNG.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_PYTHON.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_NODE.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_RUBY.
     * </p>
     * </li>
     * <li>
     * <p>
     * CALABASH.
     * </p>
     * </li>
     * <li>
     * <p>
     * INSTRUMENTATION.
     * </p>
     * </li>
     * <li>
     * <p>
     * UIAUTOMATION.
     * </p>
     * </li>
     * <li>
     * <p>
     * UIAUTOMATOR.
     * </p>
     * </li>
     * <li>
     * <p>
     * XCTEST.
     * </p>
     * </li>
     * <li>
     * <p>
     * XCTEST_UI.
     * </p>
     * </li>
     * </ul>
     * 
     * @param testType
     *        The test type for the specified device pool.</p>
     *        <p>
     *        Allowed values include the following:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        BUILTIN_FUZZ.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        BUILTIN_EXPLORER. For Android, an app explorer that traverses an Android app, interacting with it and
     *        capturing screenshots at the same time.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        APPIUM_JAVA_JUNIT.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        APPIUM_JAVA_TESTNG.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        APPIUM_PYTHON.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        APPIUM_NODE.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        APPIUM_RUBY.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        APPIUM_WEB_JAVA_JUNIT.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        APPIUM_WEB_JAVA_TESTNG.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        APPIUM_WEB_PYTHON.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        APPIUM_WEB_NODE.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        APPIUM_WEB_RUBY.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        CALABASH.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        INSTRUMENTATION.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        UIAUTOMATION.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        UIAUTOMATOR.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        XCTEST.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        XCTEST_UI.
     *        </p>
     *        </li>
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see TestType
     */

    public GetDevicePoolCompatibilityRequest withTestType(String testType) {
        setTestType(testType);
        return this;
    }

    /**
     * <p>
     * The test type for the specified device pool.
     * </p>
     * <p>
     * Allowed values include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * BUILTIN_FUZZ.
     * </p>
     * </li>
     * <li>
     * <p>
     * BUILTIN_EXPLORER. For Android, an app explorer that traverses an Android app, interacting with it and capturing
     * screenshots at the same time.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_JAVA_JUNIT.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_JAVA_TESTNG.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_PYTHON.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_NODE.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_RUBY.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_JAVA_JUNIT.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_JAVA_TESTNG.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_PYTHON.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_NODE.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_RUBY.
     * </p>
     * </li>
     * <li>
     * <p>
     * CALABASH.
     * </p>
     * </li>
     * <li>
     * <p>
     * INSTRUMENTATION.
     * </p>
     * </li>
     * <li>
     * <p>
     * UIAUTOMATION.
     * </p>
     * </li>
     * <li>
     * <p>
     * UIAUTOMATOR.
     * </p>
     * </li>
     * <li>
     * <p>
     * XCTEST.
     * </p>
     * </li>
     * <li>
     * <p>
     * XCTEST_UI.
     * </p>
     * </li>
     * </ul>
     * 
     * @param testType
     *        The test type for the specified device pool.</p>
     *        <p>
     *        Allowed values include the following:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        BUILTIN_FUZZ.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        BUILTIN_EXPLORER. For Android, an app explorer that traverses an Android app, interacting with it and
     *        capturing screenshots at the same time.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        APPIUM_JAVA_JUNIT.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        APPIUM_JAVA_TESTNG.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        APPIUM_PYTHON.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        APPIUM_NODE.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        APPIUM_RUBY.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        APPIUM_WEB_JAVA_JUNIT.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        APPIUM_WEB_JAVA_TESTNG.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        APPIUM_WEB_PYTHON.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        APPIUM_WEB_NODE.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        APPIUM_WEB_RUBY.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        CALABASH.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        INSTRUMENTATION.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        UIAUTOMATION.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        UIAUTOMATOR.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        XCTEST.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        XCTEST_UI.
     *        </p>
     *        </li>
     * @see TestType
     */

    public void setTestType(TestType testType) {
        withTestType(testType);
    }

    /**
     * <p>
     * The test type for the specified device pool.
     * </p>
     * <p>
     * Allowed values include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * BUILTIN_FUZZ.
     * </p>
     * </li>
     * <li>
     * <p>
     * BUILTIN_EXPLORER. For Android, an app explorer that traverses an Android app, interacting with it and capturing
     * screenshots at the same time.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_JAVA_JUNIT.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_JAVA_TESTNG.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_PYTHON.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_NODE.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_RUBY.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_JAVA_JUNIT.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_JAVA_TESTNG.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_PYTHON.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_NODE.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_RUBY.
     * </p>
     * </li>
     * <li>
     * <p>
     * CALABASH.
     * </p>
     * </li>
     * <li>
     * <p>
     * INSTRUMENTATION.
     * </p>
     * </li>
     * <li>
     * <p>
     * UIAUTOMATION.
     * </p>
     * </li>
     * <li>
     * <p>
     * UIAUTOMATOR.
     * </p>
     * </li>
     * <li>
     * <p>
     * XCTEST.
     * </p>
     * </li>
     * <li>
     * <p>
     * XCTEST_UI.
     * </p>
     * </li>
     * </ul>
     * 
     * @param testType
     *        The test type for the specified device pool.</p>
     *        <p>
     *        Allowed values include the following:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        BUILTIN_FUZZ.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        BUILTIN_EXPLORER. For Android, an app explorer that traverses an Android app, interacting with it and
     *        capturing screenshots at the same time.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        APPIUM_JAVA_JUNIT.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        APPIUM_JAVA_TESTNG.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        APPIUM_PYTHON.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        APPIUM_NODE.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        APPIUM_RUBY.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        APPIUM_WEB_JAVA_JUNIT.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        APPIUM_WEB_JAVA_TESTNG.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        APPIUM_WEB_PYTHON.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        APPIUM_WEB_NODE.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        APPIUM_WEB_RUBY.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        CALABASH.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        INSTRUMENTATION.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        UIAUTOMATION.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        UIAUTOMATOR.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        XCTEST.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        XCTEST_UI.
     *        </p>
     *        </li>
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see TestType
     */

    public GetDevicePoolCompatibilityRequest withTestType(TestType testType) {
        this.testType = testType.toString();
        return this;
    }

    /**
     * <p>
     * Information about the uploaded test to be run against the device pool.
     * </p>
     * 
     * @param test
     *        Information about the uploaded test to be run against the device pool.
     */

    public void setTest(ScheduleRunTest test) {
        this.test = test;
    }

    /**
     * <p>
     * Information about the uploaded test to be run against the device pool.
     * </p>
     * 
     * @return Information about the uploaded test to be run against the device pool.
     */

    public ScheduleRunTest getTest() {
        return this.test;
    }

    /**
     * <p>
     * Information about the uploaded test to be run against the device pool.
     * </p>
     * 
     * @param test
     *        Information about the uploaded test to be run against the device pool.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetDevicePoolCompatibilityRequest withTest(ScheduleRunTest test) {
        setTest(test);
        return this;
    }

    /**
     * <p>
     * An object that contains information about the settings for a run.
     * </p>
     * 
     * @param configuration
     *        An object that contains information about the settings for a run.
     */

    public void setConfiguration(ScheduleRunConfiguration configuration) {
        this.configuration = configuration;
    }

    /**
     * <p>
     * An object that contains information about the settings for a run.
     * </p>
     * 
     * @return An object that contains information about the settings for a run.
     */

    public ScheduleRunConfiguration getConfiguration() {
        return this.configuration;
    }

    /**
     * <p>
     * An object that contains information about the settings for a run.
     * </p>
     * 
     * @param configuration
     *        An object that contains information about the settings for a run.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetDevicePoolCompatibilityRequest withConfiguration(ScheduleRunConfiguration configuration) {
        setConfiguration(configuration);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getDevicePoolArn() != null)
            sb.append("DevicePoolArn: ").append(getDevicePoolArn()).append(",");
        if (getAppArn() != null)
            sb.append("AppArn: ").append(getAppArn()).append(",");
        if (getTestType() != null)
            sb.append("TestType: ").append(getTestType()).append(",");
        if (getTest() != null)
            sb.append("Test: ").append(getTest()).append(",");
        if (getConfiguration() != null)
            sb.append("Configuration: ").append(getConfiguration());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof GetDevicePoolCompatibilityRequest == false)
            return false;
        GetDevicePoolCompatibilityRequest other = (GetDevicePoolCompatibilityRequest) obj;
        if (other.getDevicePoolArn() == null ^ this.getDevicePoolArn() == null)
            return false;
        if (other.getDevicePoolArn() != null && other.getDevicePoolArn().equals(this.getDevicePoolArn()) == false)
            return false;
        if (other.getAppArn() == null ^ this.getAppArn() == null)
            return false;
        if (other.getAppArn() != null && other.getAppArn().equals(this.getAppArn()) == false)
            return false;
        if (other.getTestType() == null ^ this.getTestType() == null)
            return false;
        if (other.getTestType() != null && other.getTestType().equals(this.getTestType()) == false)
            return false;
        if (other.getTest() == null ^ this.getTest() == null)
            return false;
        if (other.getTest() != null && other.getTest().equals(this.getTest()) == false)
            return false;
        if (other.getConfiguration() == null ^ this.getConfiguration() == null)
            return false;
        if (other.getConfiguration() != null && other.getConfiguration().equals(this.getConfiguration()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getDevicePoolArn() == null) ? 0 : getDevicePoolArn().hashCode());
        hashCode = prime * hashCode + ((getAppArn() == null) ? 0 : getAppArn().hashCode());
        hashCode = prime * hashCode + ((getTestType() == null) ? 0 : getTestType().hashCode());
        hashCode = prime * hashCode + ((getTest() == null) ? 0 : getTest().hashCode());
        hashCode = prime * hashCode + ((getConfiguration() == null) ? 0 : getConfiguration().hashCode());
        return hashCode;
    }

    @Override
    public GetDevicePoolCompatibilityRequest clone() {
        return (GetDevicePoolCompatibilityRequest) super.clone();
    }

}
