/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

/**
 * <p>
 * Welcome to the AWS Device Farm API documentation, which contains APIs for:
 * </p>
 * <ul>
 * <li>
 * <p>
 * Testing on desktop browsers
 * </p>
 * <p>
 * Device Farm makes it possible for you to test your web applications on desktop browsers using Selenium. The APIs for
 * desktop browser testing contain <code>TestGrid</code> in their names. For more information, see <a
 * href="https://docs.aws.amazon.com/devicefarm/latest/testgrid/">Testing Web Applications on Selenium with Device
 * Farm</a>.
 * </p>
 * </li>
 * <li>
 * <p>
 * Testing on real mobile devices
 * </p>
 * <p>
 * Device Farm makes it possible for you to test apps on physical phones, tablets, and other devices in the cloud. For
 * more information, see the <a href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/">Device Farm
 * Developer Guide</a>.
 * </p>
 * </li>
 * </ul>
 */
package com.amazonaws.services.devicefarm;

