/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.devicefarm;

import javax.annotation.Generated;

import com.amazonaws.services.devicefarm.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AWSDeviceFarm}. Convenient method forms pass through to the corresponding overload
 * that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSDeviceFarm implements AWSDeviceFarm {

    protected AbstractAWSDeviceFarm() {
    }

    @Override
    public void setEndpoint(String endpoint) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void setRegion(com.amazonaws.regions.Region region) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateDevicePoolResult createDevicePool(CreateDevicePoolRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateInstanceProfileResult createInstanceProfile(CreateInstanceProfileRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateNetworkProfileResult createNetworkProfile(CreateNetworkProfileRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateProjectResult createProject(CreateProjectRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateRemoteAccessSessionResult createRemoteAccessSession(CreateRemoteAccessSessionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateTestGridProjectResult createTestGridProject(CreateTestGridProjectRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateTestGridUrlResult createTestGridUrl(CreateTestGridUrlRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateUploadResult createUpload(CreateUploadRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateVPCEConfigurationResult createVPCEConfiguration(CreateVPCEConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteDevicePoolResult deleteDevicePool(DeleteDevicePoolRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteInstanceProfileResult deleteInstanceProfile(DeleteInstanceProfileRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteNetworkProfileResult deleteNetworkProfile(DeleteNetworkProfileRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteProjectResult deleteProject(DeleteProjectRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteRemoteAccessSessionResult deleteRemoteAccessSession(DeleteRemoteAccessSessionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteRunResult deleteRun(DeleteRunRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteTestGridProjectResult deleteTestGridProject(DeleteTestGridProjectRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteUploadResult deleteUpload(DeleteUploadRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteVPCEConfigurationResult deleteVPCEConfiguration(DeleteVPCEConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetAccountSettingsResult getAccountSettings(GetAccountSettingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetDeviceResult getDevice(GetDeviceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetDeviceInstanceResult getDeviceInstance(GetDeviceInstanceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetDevicePoolResult getDevicePool(GetDevicePoolRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetDevicePoolCompatibilityResult getDevicePoolCompatibility(GetDevicePoolCompatibilityRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetInstanceProfileResult getInstanceProfile(GetInstanceProfileRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetJobResult getJob(GetJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetNetworkProfileResult getNetworkProfile(GetNetworkProfileRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetOfferingStatusResult getOfferingStatus(GetOfferingStatusRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetProjectResult getProject(GetProjectRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetRemoteAccessSessionResult getRemoteAccessSession(GetRemoteAccessSessionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetRunResult getRun(GetRunRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetSuiteResult getSuite(GetSuiteRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetTestResult getTest(GetTestRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetTestGridProjectResult getTestGridProject(GetTestGridProjectRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetTestGridSessionResult getTestGridSession(GetTestGridSessionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetUploadResult getUpload(GetUploadRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetVPCEConfigurationResult getVPCEConfiguration(GetVPCEConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public InstallToRemoteAccessSessionResult installToRemoteAccessSession(InstallToRemoteAccessSessionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListArtifactsResult listArtifacts(ListArtifactsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDeviceInstancesResult listDeviceInstances(ListDeviceInstancesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDevicePoolsResult listDevicePools(ListDevicePoolsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDevicesResult listDevices(ListDevicesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListInstanceProfilesResult listInstanceProfiles(ListInstanceProfilesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListJobsResult listJobs(ListJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListNetworkProfilesResult listNetworkProfiles(ListNetworkProfilesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListOfferingPromotionsResult listOfferingPromotions(ListOfferingPromotionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListOfferingTransactionsResult listOfferingTransactions(ListOfferingTransactionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListOfferingsResult listOfferings(ListOfferingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListProjectsResult listProjects(ListProjectsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListRemoteAccessSessionsResult listRemoteAccessSessions(ListRemoteAccessSessionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListRunsResult listRuns(ListRunsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListSamplesResult listSamples(ListSamplesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListSuitesResult listSuites(ListSuitesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTestGridProjectsResult listTestGridProjects(ListTestGridProjectsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTestGridSessionActionsResult listTestGridSessionActions(ListTestGridSessionActionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTestGridSessionArtifactsResult listTestGridSessionArtifacts(ListTestGridSessionArtifactsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTestGridSessionsResult listTestGridSessions(ListTestGridSessionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTestsResult listTests(ListTestsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListUniqueProblemsResult listUniqueProblems(ListUniqueProblemsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListUploadsResult listUploads(ListUploadsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListVPCEConfigurationsResult listVPCEConfigurations(ListVPCEConfigurationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PurchaseOfferingResult purchaseOffering(PurchaseOfferingRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RenewOfferingResult renewOffering(RenewOfferingRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ScheduleRunResult scheduleRun(ScheduleRunRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StopJobResult stopJob(StopJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StopRemoteAccessSessionResult stopRemoteAccessSession(StopRemoteAccessSessionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StopRunResult stopRun(StopRunRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateDeviceInstanceResult updateDeviceInstance(UpdateDeviceInstanceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateDevicePoolResult updateDevicePool(UpdateDevicePoolRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateInstanceProfileResult updateInstanceProfile(UpdateInstanceProfileRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateNetworkProfileResult updateNetworkProfile(UpdateNetworkProfileRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateProjectResult updateProject(UpdateProjectRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateTestGridProjectResult updateTestGridProject(UpdateTestGridProjectRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateUploadResult updateUpload(UpdateUploadRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateVPCEConfigurationResult updateVPCEConfiguration(UpdateVPCEConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
