/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.devopsguru.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.devopsguru.model.CloudFormationHealth;

@SdkInternalApi
public class CloudFormationHealthMarshaller {
    private static final MarshallingInfo<String> STACKNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StackName").build();
    private static final MarshallingInfo<StructuredPojo> INSIGHT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Insight").build();
    private static final CloudFormationHealthMarshaller instance = new CloudFormationHealthMarshaller();

    public static CloudFormationHealthMarshaller getInstance() {
        return instance;
    }

    public void marshall(CloudFormationHealth cloudFormationHealth, ProtocolMarshaller protocolMarshaller) {
        if (cloudFormationHealth == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)cloudFormationHealth.getStackName(), STACKNAME_BINDING);
            protocolMarshaller.marshall((Object)cloudFormationHealth.getInsight(), INSIGHT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

