/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.devopsguru;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.devopsguru.AmazonDevOpsGuru;
import com.amazonaws.services.devopsguru.AmazonDevOpsGuruClientBuilder;
import com.amazonaws.services.devopsguru.model.AddNotificationChannelRequest;
import com.amazonaws.services.devopsguru.model.AddNotificationChannelResult;
import com.amazonaws.services.devopsguru.model.AmazonDevOpsGuruException;
import com.amazonaws.services.devopsguru.model.DeleteInsightRequest;
import com.amazonaws.services.devopsguru.model.DeleteInsightResult;
import com.amazonaws.services.devopsguru.model.DescribeAccountHealthRequest;
import com.amazonaws.services.devopsguru.model.DescribeAccountHealthResult;
import com.amazonaws.services.devopsguru.model.DescribeAccountOverviewRequest;
import com.amazonaws.services.devopsguru.model.DescribeAccountOverviewResult;
import com.amazonaws.services.devopsguru.model.DescribeAnomalyRequest;
import com.amazonaws.services.devopsguru.model.DescribeAnomalyResult;
import com.amazonaws.services.devopsguru.model.DescribeEventSourcesConfigRequest;
import com.amazonaws.services.devopsguru.model.DescribeEventSourcesConfigResult;
import com.amazonaws.services.devopsguru.model.DescribeFeedbackRequest;
import com.amazonaws.services.devopsguru.model.DescribeFeedbackResult;
import com.amazonaws.services.devopsguru.model.DescribeInsightRequest;
import com.amazonaws.services.devopsguru.model.DescribeInsightResult;
import com.amazonaws.services.devopsguru.model.DescribeOrganizationHealthRequest;
import com.amazonaws.services.devopsguru.model.DescribeOrganizationHealthResult;
import com.amazonaws.services.devopsguru.model.DescribeOrganizationOverviewRequest;
import com.amazonaws.services.devopsguru.model.DescribeOrganizationOverviewResult;
import com.amazonaws.services.devopsguru.model.DescribeOrganizationResourceCollectionHealthRequest;
import com.amazonaws.services.devopsguru.model.DescribeOrganizationResourceCollectionHealthResult;
import com.amazonaws.services.devopsguru.model.DescribeResourceCollectionHealthRequest;
import com.amazonaws.services.devopsguru.model.DescribeResourceCollectionHealthResult;
import com.amazonaws.services.devopsguru.model.DescribeServiceIntegrationRequest;
import com.amazonaws.services.devopsguru.model.DescribeServiceIntegrationResult;
import com.amazonaws.services.devopsguru.model.GetCostEstimationRequest;
import com.amazonaws.services.devopsguru.model.GetCostEstimationResult;
import com.amazonaws.services.devopsguru.model.GetResourceCollectionRequest;
import com.amazonaws.services.devopsguru.model.GetResourceCollectionResult;
import com.amazonaws.services.devopsguru.model.ListAnomaliesForInsightRequest;
import com.amazonaws.services.devopsguru.model.ListAnomaliesForInsightResult;
import com.amazonaws.services.devopsguru.model.ListEventsRequest;
import com.amazonaws.services.devopsguru.model.ListEventsResult;
import com.amazonaws.services.devopsguru.model.ListInsightsRequest;
import com.amazonaws.services.devopsguru.model.ListInsightsResult;
import com.amazonaws.services.devopsguru.model.ListNotificationChannelsRequest;
import com.amazonaws.services.devopsguru.model.ListNotificationChannelsResult;
import com.amazonaws.services.devopsguru.model.ListOrganizationInsightsRequest;
import com.amazonaws.services.devopsguru.model.ListOrganizationInsightsResult;
import com.amazonaws.services.devopsguru.model.ListRecommendationsRequest;
import com.amazonaws.services.devopsguru.model.ListRecommendationsResult;
import com.amazonaws.services.devopsguru.model.PutFeedbackRequest;
import com.amazonaws.services.devopsguru.model.PutFeedbackResult;
import com.amazonaws.services.devopsguru.model.RemoveNotificationChannelRequest;
import com.amazonaws.services.devopsguru.model.RemoveNotificationChannelResult;
import com.amazonaws.services.devopsguru.model.SearchInsightsRequest;
import com.amazonaws.services.devopsguru.model.SearchInsightsResult;
import com.amazonaws.services.devopsguru.model.SearchOrganizationInsightsRequest;
import com.amazonaws.services.devopsguru.model.SearchOrganizationInsightsResult;
import com.amazonaws.services.devopsguru.model.StartCostEstimationRequest;
import com.amazonaws.services.devopsguru.model.StartCostEstimationResult;
import com.amazonaws.services.devopsguru.model.UpdateEventSourcesConfigRequest;
import com.amazonaws.services.devopsguru.model.UpdateEventSourcesConfigResult;
import com.amazonaws.services.devopsguru.model.UpdateResourceCollectionRequest;
import com.amazonaws.services.devopsguru.model.UpdateResourceCollectionResult;
import com.amazonaws.services.devopsguru.model.UpdateServiceIntegrationRequest;
import com.amazonaws.services.devopsguru.model.UpdateServiceIntegrationResult;
import com.amazonaws.services.devopsguru.model.transform.AccessDeniedExceptionUnmarshaller;
import com.amazonaws.services.devopsguru.model.transform.AddNotificationChannelRequestProtocolMarshaller;
import com.amazonaws.services.devopsguru.model.transform.AddNotificationChannelResultJsonUnmarshaller;
import com.amazonaws.services.devopsguru.model.transform.ConflictExceptionUnmarshaller;
import com.amazonaws.services.devopsguru.model.transform.DeleteInsightRequestProtocolMarshaller;
import com.amazonaws.services.devopsguru.model.transform.DeleteInsightResultJsonUnmarshaller;
import com.amazonaws.services.devopsguru.model.transform.DescribeAccountHealthRequestProtocolMarshaller;
import com.amazonaws.services.devopsguru.model.transform.DescribeAccountHealthResultJsonUnmarshaller;
import com.amazonaws.services.devopsguru.model.transform.DescribeAccountOverviewRequestProtocolMarshaller;
import com.amazonaws.services.devopsguru.model.transform.DescribeAccountOverviewResultJsonUnmarshaller;
import com.amazonaws.services.devopsguru.model.transform.DescribeAnomalyRequestProtocolMarshaller;
import com.amazonaws.services.devopsguru.model.transform.DescribeAnomalyResultJsonUnmarshaller;
import com.amazonaws.services.devopsguru.model.transform.DescribeEventSourcesConfigRequestProtocolMarshaller;
import com.amazonaws.services.devopsguru.model.transform.DescribeEventSourcesConfigResultJsonUnmarshaller;
import com.amazonaws.services.devopsguru.model.transform.DescribeFeedbackRequestProtocolMarshaller;
import com.amazonaws.services.devopsguru.model.transform.DescribeFeedbackResultJsonUnmarshaller;
import com.amazonaws.services.devopsguru.model.transform.DescribeInsightRequestProtocolMarshaller;
import com.amazonaws.services.devopsguru.model.transform.DescribeInsightResultJsonUnmarshaller;
import com.amazonaws.services.devopsguru.model.transform.DescribeOrganizationHealthRequestProtocolMarshaller;
import com.amazonaws.services.devopsguru.model.transform.DescribeOrganizationHealthResultJsonUnmarshaller;
import com.amazonaws.services.devopsguru.model.transform.DescribeOrganizationOverviewRequestProtocolMarshaller;
import com.amazonaws.services.devopsguru.model.transform.DescribeOrganizationOverviewResultJsonUnmarshaller;
import com.amazonaws.services.devopsguru.model.transform.DescribeOrganizationResourceCollectionHealthRequestProtocolMarshaller;
import com.amazonaws.services.devopsguru.model.transform.DescribeOrganizationResourceCollectionHealthResultJsonUnmarshaller;
import com.amazonaws.services.devopsguru.model.transform.DescribeResourceCollectionHealthRequestProtocolMarshaller;
import com.amazonaws.services.devopsguru.model.transform.DescribeResourceCollectionHealthResultJsonUnmarshaller;
import com.amazonaws.services.devopsguru.model.transform.DescribeServiceIntegrationRequestProtocolMarshaller;
import com.amazonaws.services.devopsguru.model.transform.DescribeServiceIntegrationResultJsonUnmarshaller;
import com.amazonaws.services.devopsguru.model.transform.GetCostEstimationRequestProtocolMarshaller;
import com.amazonaws.services.devopsguru.model.transform.GetCostEstimationResultJsonUnmarshaller;
import com.amazonaws.services.devopsguru.model.transform.GetResourceCollectionRequestProtocolMarshaller;
import com.amazonaws.services.devopsguru.model.transform.GetResourceCollectionResultJsonUnmarshaller;
import com.amazonaws.services.devopsguru.model.transform.InternalServerExceptionUnmarshaller;
import com.amazonaws.services.devopsguru.model.transform.ListAnomaliesForInsightRequestProtocolMarshaller;
import com.amazonaws.services.devopsguru.model.transform.ListAnomaliesForInsightResultJsonUnmarshaller;
import com.amazonaws.services.devopsguru.model.transform.ListEventsRequestProtocolMarshaller;
import com.amazonaws.services.devopsguru.model.transform.ListEventsResultJsonUnmarshaller;
import com.amazonaws.services.devopsguru.model.transform.ListInsightsRequestProtocolMarshaller;
import com.amazonaws.services.devopsguru.model.transform.ListInsightsResultJsonUnmarshaller;
import com.amazonaws.services.devopsguru.model.transform.ListNotificationChannelsRequestProtocolMarshaller;
import com.amazonaws.services.devopsguru.model.transform.ListNotificationChannelsResultJsonUnmarshaller;
import com.amazonaws.services.devopsguru.model.transform.ListOrganizationInsightsRequestProtocolMarshaller;
import com.amazonaws.services.devopsguru.model.transform.ListOrganizationInsightsResultJsonUnmarshaller;
import com.amazonaws.services.devopsguru.model.transform.ListRecommendationsRequestProtocolMarshaller;
import com.amazonaws.services.devopsguru.model.transform.ListRecommendationsResultJsonUnmarshaller;
import com.amazonaws.services.devopsguru.model.transform.PutFeedbackRequestProtocolMarshaller;
import com.amazonaws.services.devopsguru.model.transform.PutFeedbackResultJsonUnmarshaller;
import com.amazonaws.services.devopsguru.model.transform.RemoveNotificationChannelRequestProtocolMarshaller;
import com.amazonaws.services.devopsguru.model.transform.RemoveNotificationChannelResultJsonUnmarshaller;
import com.amazonaws.services.devopsguru.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.devopsguru.model.transform.SearchInsightsRequestProtocolMarshaller;
import com.amazonaws.services.devopsguru.model.transform.SearchInsightsResultJsonUnmarshaller;
import com.amazonaws.services.devopsguru.model.transform.SearchOrganizationInsightsRequestProtocolMarshaller;
import com.amazonaws.services.devopsguru.model.transform.SearchOrganizationInsightsResultJsonUnmarshaller;
import com.amazonaws.services.devopsguru.model.transform.ServiceQuotaExceededExceptionUnmarshaller;
import com.amazonaws.services.devopsguru.model.transform.StartCostEstimationRequestProtocolMarshaller;
import com.amazonaws.services.devopsguru.model.transform.StartCostEstimationResultJsonUnmarshaller;
import com.amazonaws.services.devopsguru.model.transform.ThrottlingExceptionUnmarshaller;
import com.amazonaws.services.devopsguru.model.transform.UpdateEventSourcesConfigRequestProtocolMarshaller;
import com.amazonaws.services.devopsguru.model.transform.UpdateEventSourcesConfigResultJsonUnmarshaller;
import com.amazonaws.services.devopsguru.model.transform.UpdateResourceCollectionRequestProtocolMarshaller;
import com.amazonaws.services.devopsguru.model.transform.UpdateResourceCollectionResultJsonUnmarshaller;
import com.amazonaws.services.devopsguru.model.transform.UpdateServiceIntegrationRequestProtocolMarshaller;
import com.amazonaws.services.devopsguru.model.transform.UpdateServiceIntegrationResultJsonUnmarshaller;
import com.amazonaws.services.devopsguru.model.transform.ValidationExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AmazonDevOpsGuruClient
extends AmazonWebServiceClient
implements AmazonDevOpsGuru {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonDevOpsGuru.class);
    private static final String DEFAULT_SIGNING_NAME = "devops-guru";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("application/json").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ThrottlingException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ThrottlingExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceQuotaExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ServiceQuotaExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServerExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)AccessDeniedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConflictException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ConflictExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ValidationExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AmazonDevOpsGuruException.class));

    public static AmazonDevOpsGuruClientBuilder builder() {
        return AmazonDevOpsGuruClientBuilder.standard();
    }

    AmazonDevOpsGuruClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AmazonDevOpsGuruClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("devops-guru.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/devopsguru/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/devopsguru/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public AddNotificationChannelResult addNotificationChannel(AddNotificationChannelRequest request) {
        request = (AddNotificationChannelRequest)this.beforeClientExecution(request);
        return this.executeAddNotificationChannel(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final AddNotificationChannelResult executeAddNotificationChannel(AddNotificationChannelRequest addNotificationChannelRequest) {
        ExecutionContext executionContext = this.createExecutionContext(addNotificationChannelRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AddNotificationChannelRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AddNotificationChannelRequestProtocolMarshaller(protocolFactory).marshall((AddNotificationChannelRequest)super.beforeMarshalling((AmazonWebServiceRequest)addNotificationChannelRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"DevOps Guru");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"AddNotificationChannel");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new AddNotificationChannelResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            AddNotificationChannelResult addNotificationChannelResult = (AddNotificationChannelResult)response.getAwsResponse();
            return addNotificationChannelResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteInsightResult deleteInsight(DeleteInsightRequest request) {
        request = (DeleteInsightRequest)this.beforeClientExecution(request);
        return this.executeDeleteInsight(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteInsightResult executeDeleteInsight(DeleteInsightRequest deleteInsightRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteInsightRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteInsightRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteInsightRequestProtocolMarshaller(protocolFactory).marshall((DeleteInsightRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteInsightRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"DevOps Guru");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteInsight");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteInsightResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteInsightResult deleteInsightResult = (DeleteInsightResult)response.getAwsResponse();
            return deleteInsightResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeAccountHealthResult describeAccountHealth(DescribeAccountHealthRequest request) {
        request = (DescribeAccountHealthRequest)this.beforeClientExecution(request);
        return this.executeDescribeAccountHealth(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeAccountHealthResult executeDescribeAccountHealth(DescribeAccountHealthRequest describeAccountHealthRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeAccountHealthRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeAccountHealthRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeAccountHealthRequestProtocolMarshaller(protocolFactory).marshall((DescribeAccountHealthRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeAccountHealthRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"DevOps Guru");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeAccountHealth");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeAccountHealthResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeAccountHealthResult describeAccountHealthResult = (DescribeAccountHealthResult)response.getAwsResponse();
            return describeAccountHealthResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeAccountOverviewResult describeAccountOverview(DescribeAccountOverviewRequest request) {
        request = (DescribeAccountOverviewRequest)this.beforeClientExecution(request);
        return this.executeDescribeAccountOverview(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeAccountOverviewResult executeDescribeAccountOverview(DescribeAccountOverviewRequest describeAccountOverviewRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeAccountOverviewRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeAccountOverviewRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeAccountOverviewRequestProtocolMarshaller(protocolFactory).marshall((DescribeAccountOverviewRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeAccountOverviewRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"DevOps Guru");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeAccountOverview");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeAccountOverviewResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeAccountOverviewResult describeAccountOverviewResult = (DescribeAccountOverviewResult)response.getAwsResponse();
            return describeAccountOverviewResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeAnomalyResult describeAnomaly(DescribeAnomalyRequest request) {
        request = (DescribeAnomalyRequest)this.beforeClientExecution(request);
        return this.executeDescribeAnomaly(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeAnomalyResult executeDescribeAnomaly(DescribeAnomalyRequest describeAnomalyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeAnomalyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeAnomalyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeAnomalyRequestProtocolMarshaller(protocolFactory).marshall((DescribeAnomalyRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeAnomalyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"DevOps Guru");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeAnomaly");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeAnomalyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeAnomalyResult describeAnomalyResult = (DescribeAnomalyResult)response.getAwsResponse();
            return describeAnomalyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeEventSourcesConfigResult describeEventSourcesConfig(DescribeEventSourcesConfigRequest request) {
        request = (DescribeEventSourcesConfigRequest)this.beforeClientExecution(request);
        return this.executeDescribeEventSourcesConfig(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeEventSourcesConfigResult executeDescribeEventSourcesConfig(DescribeEventSourcesConfigRequest describeEventSourcesConfigRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeEventSourcesConfigRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeEventSourcesConfigRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeEventSourcesConfigRequestProtocolMarshaller(protocolFactory).marshall((DescribeEventSourcesConfigRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeEventSourcesConfigRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"DevOps Guru");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeEventSourcesConfig");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeEventSourcesConfigResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeEventSourcesConfigResult describeEventSourcesConfigResult = (DescribeEventSourcesConfigResult)response.getAwsResponse();
            return describeEventSourcesConfigResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeFeedbackResult describeFeedback(DescribeFeedbackRequest request) {
        request = (DescribeFeedbackRequest)this.beforeClientExecution(request);
        return this.executeDescribeFeedback(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeFeedbackResult executeDescribeFeedback(DescribeFeedbackRequest describeFeedbackRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeFeedbackRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeFeedbackRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeFeedbackRequestProtocolMarshaller(protocolFactory).marshall((DescribeFeedbackRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeFeedbackRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"DevOps Guru");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeFeedback");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeFeedbackResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeFeedbackResult describeFeedbackResult = (DescribeFeedbackResult)response.getAwsResponse();
            return describeFeedbackResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeInsightResult describeInsight(DescribeInsightRequest request) {
        request = (DescribeInsightRequest)this.beforeClientExecution(request);
        return this.executeDescribeInsight(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeInsightResult executeDescribeInsight(DescribeInsightRequest describeInsightRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeInsightRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeInsightRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeInsightRequestProtocolMarshaller(protocolFactory).marshall((DescribeInsightRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeInsightRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"DevOps Guru");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeInsight");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeInsightResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeInsightResult describeInsightResult = (DescribeInsightResult)response.getAwsResponse();
            return describeInsightResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeOrganizationHealthResult describeOrganizationHealth(DescribeOrganizationHealthRequest request) {
        request = (DescribeOrganizationHealthRequest)this.beforeClientExecution(request);
        return this.executeDescribeOrganizationHealth(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeOrganizationHealthResult executeDescribeOrganizationHealth(DescribeOrganizationHealthRequest describeOrganizationHealthRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeOrganizationHealthRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeOrganizationHealthRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeOrganizationHealthRequestProtocolMarshaller(protocolFactory).marshall((DescribeOrganizationHealthRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeOrganizationHealthRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"DevOps Guru");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeOrganizationHealth");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeOrganizationHealthResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeOrganizationHealthResult describeOrganizationHealthResult = (DescribeOrganizationHealthResult)response.getAwsResponse();
            return describeOrganizationHealthResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeOrganizationOverviewResult describeOrganizationOverview(DescribeOrganizationOverviewRequest request) {
        request = (DescribeOrganizationOverviewRequest)this.beforeClientExecution(request);
        return this.executeDescribeOrganizationOverview(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeOrganizationOverviewResult executeDescribeOrganizationOverview(DescribeOrganizationOverviewRequest describeOrganizationOverviewRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeOrganizationOverviewRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeOrganizationOverviewRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeOrganizationOverviewRequestProtocolMarshaller(protocolFactory).marshall((DescribeOrganizationOverviewRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeOrganizationOverviewRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"DevOps Guru");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeOrganizationOverview");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeOrganizationOverviewResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeOrganizationOverviewResult describeOrganizationOverviewResult = (DescribeOrganizationOverviewResult)response.getAwsResponse();
            return describeOrganizationOverviewResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeOrganizationResourceCollectionHealthResult describeOrganizationResourceCollectionHealth(DescribeOrganizationResourceCollectionHealthRequest request) {
        request = (DescribeOrganizationResourceCollectionHealthRequest)this.beforeClientExecution(request);
        return this.executeDescribeOrganizationResourceCollectionHealth(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeOrganizationResourceCollectionHealthResult executeDescribeOrganizationResourceCollectionHealth(DescribeOrganizationResourceCollectionHealthRequest describeOrganizationResourceCollectionHealthRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeOrganizationResourceCollectionHealthRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeOrganizationResourceCollectionHealthRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeOrganizationResourceCollectionHealthRequestProtocolMarshaller(protocolFactory).marshall((DescribeOrganizationResourceCollectionHealthRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeOrganizationResourceCollectionHealthRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"DevOps Guru");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeOrganizationResourceCollectionHealth");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeOrganizationResourceCollectionHealthResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeOrganizationResourceCollectionHealthResult describeOrganizationResourceCollectionHealthResult = (DescribeOrganizationResourceCollectionHealthResult)response.getAwsResponse();
            return describeOrganizationResourceCollectionHealthResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeResourceCollectionHealthResult describeResourceCollectionHealth(DescribeResourceCollectionHealthRequest request) {
        request = (DescribeResourceCollectionHealthRequest)this.beforeClientExecution(request);
        return this.executeDescribeResourceCollectionHealth(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeResourceCollectionHealthResult executeDescribeResourceCollectionHealth(DescribeResourceCollectionHealthRequest describeResourceCollectionHealthRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeResourceCollectionHealthRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeResourceCollectionHealthRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeResourceCollectionHealthRequestProtocolMarshaller(protocolFactory).marshall((DescribeResourceCollectionHealthRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeResourceCollectionHealthRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"DevOps Guru");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeResourceCollectionHealth");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeResourceCollectionHealthResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeResourceCollectionHealthResult describeResourceCollectionHealthResult = (DescribeResourceCollectionHealthResult)response.getAwsResponse();
            return describeResourceCollectionHealthResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeServiceIntegrationResult describeServiceIntegration(DescribeServiceIntegrationRequest request) {
        request = (DescribeServiceIntegrationRequest)this.beforeClientExecution(request);
        return this.executeDescribeServiceIntegration(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeServiceIntegrationResult executeDescribeServiceIntegration(DescribeServiceIntegrationRequest describeServiceIntegrationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeServiceIntegrationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeServiceIntegrationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeServiceIntegrationRequestProtocolMarshaller(protocolFactory).marshall((DescribeServiceIntegrationRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeServiceIntegrationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"DevOps Guru");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeServiceIntegration");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeServiceIntegrationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeServiceIntegrationResult describeServiceIntegrationResult = (DescribeServiceIntegrationResult)response.getAwsResponse();
            return describeServiceIntegrationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetCostEstimationResult getCostEstimation(GetCostEstimationRequest request) {
        request = (GetCostEstimationRequest)this.beforeClientExecution(request);
        return this.executeGetCostEstimation(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetCostEstimationResult executeGetCostEstimation(GetCostEstimationRequest getCostEstimationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getCostEstimationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetCostEstimationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetCostEstimationRequestProtocolMarshaller(protocolFactory).marshall((GetCostEstimationRequest)super.beforeMarshalling((AmazonWebServiceRequest)getCostEstimationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"DevOps Guru");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetCostEstimation");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetCostEstimationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetCostEstimationResult getCostEstimationResult = (GetCostEstimationResult)response.getAwsResponse();
            return getCostEstimationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetResourceCollectionResult getResourceCollection(GetResourceCollectionRequest request) {
        request = (GetResourceCollectionRequest)this.beforeClientExecution(request);
        return this.executeGetResourceCollection(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetResourceCollectionResult executeGetResourceCollection(GetResourceCollectionRequest getResourceCollectionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getResourceCollectionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetResourceCollectionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetResourceCollectionRequestProtocolMarshaller(protocolFactory).marshall((GetResourceCollectionRequest)super.beforeMarshalling((AmazonWebServiceRequest)getResourceCollectionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"DevOps Guru");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetResourceCollection");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetResourceCollectionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetResourceCollectionResult getResourceCollectionResult = (GetResourceCollectionResult)response.getAwsResponse();
            return getResourceCollectionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListAnomaliesForInsightResult listAnomaliesForInsight(ListAnomaliesForInsightRequest request) {
        request = (ListAnomaliesForInsightRequest)this.beforeClientExecution(request);
        return this.executeListAnomaliesForInsight(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListAnomaliesForInsightResult executeListAnomaliesForInsight(ListAnomaliesForInsightRequest listAnomaliesForInsightRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listAnomaliesForInsightRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListAnomaliesForInsightRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListAnomaliesForInsightRequestProtocolMarshaller(protocolFactory).marshall((ListAnomaliesForInsightRequest)super.beforeMarshalling((AmazonWebServiceRequest)listAnomaliesForInsightRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"DevOps Guru");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListAnomaliesForInsight");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListAnomaliesForInsightResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListAnomaliesForInsightResult listAnomaliesForInsightResult = (ListAnomaliesForInsightResult)response.getAwsResponse();
            return listAnomaliesForInsightResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListEventsResult listEvents(ListEventsRequest request) {
        request = (ListEventsRequest)this.beforeClientExecution(request);
        return this.executeListEvents(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListEventsResult executeListEvents(ListEventsRequest listEventsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listEventsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListEventsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListEventsRequestProtocolMarshaller(protocolFactory).marshall((ListEventsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listEventsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"DevOps Guru");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListEvents");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListEventsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListEventsResult listEventsResult = (ListEventsResult)response.getAwsResponse();
            return listEventsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListInsightsResult listInsights(ListInsightsRequest request) {
        request = (ListInsightsRequest)this.beforeClientExecution(request);
        return this.executeListInsights(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListInsightsResult executeListInsights(ListInsightsRequest listInsightsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listInsightsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListInsightsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListInsightsRequestProtocolMarshaller(protocolFactory).marshall((ListInsightsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listInsightsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"DevOps Guru");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListInsights");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListInsightsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListInsightsResult listInsightsResult = (ListInsightsResult)response.getAwsResponse();
            return listInsightsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListNotificationChannelsResult listNotificationChannels(ListNotificationChannelsRequest request) {
        request = (ListNotificationChannelsRequest)this.beforeClientExecution(request);
        return this.executeListNotificationChannels(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListNotificationChannelsResult executeListNotificationChannels(ListNotificationChannelsRequest listNotificationChannelsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listNotificationChannelsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListNotificationChannelsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListNotificationChannelsRequestProtocolMarshaller(protocolFactory).marshall((ListNotificationChannelsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listNotificationChannelsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"DevOps Guru");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListNotificationChannels");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListNotificationChannelsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListNotificationChannelsResult listNotificationChannelsResult = (ListNotificationChannelsResult)response.getAwsResponse();
            return listNotificationChannelsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListOrganizationInsightsResult listOrganizationInsights(ListOrganizationInsightsRequest request) {
        request = (ListOrganizationInsightsRequest)this.beforeClientExecution(request);
        return this.executeListOrganizationInsights(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListOrganizationInsightsResult executeListOrganizationInsights(ListOrganizationInsightsRequest listOrganizationInsightsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listOrganizationInsightsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListOrganizationInsightsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListOrganizationInsightsRequestProtocolMarshaller(protocolFactory).marshall((ListOrganizationInsightsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listOrganizationInsightsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"DevOps Guru");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListOrganizationInsights");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListOrganizationInsightsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListOrganizationInsightsResult listOrganizationInsightsResult = (ListOrganizationInsightsResult)response.getAwsResponse();
            return listOrganizationInsightsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListRecommendationsResult listRecommendations(ListRecommendationsRequest request) {
        request = (ListRecommendationsRequest)this.beforeClientExecution(request);
        return this.executeListRecommendations(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListRecommendationsResult executeListRecommendations(ListRecommendationsRequest listRecommendationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listRecommendationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListRecommendationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListRecommendationsRequestProtocolMarshaller(protocolFactory).marshall((ListRecommendationsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listRecommendationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"DevOps Guru");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListRecommendations");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListRecommendationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListRecommendationsResult listRecommendationsResult = (ListRecommendationsResult)response.getAwsResponse();
            return listRecommendationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutFeedbackResult putFeedback(PutFeedbackRequest request) {
        request = (PutFeedbackRequest)this.beforeClientExecution(request);
        return this.executePutFeedback(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutFeedbackResult executePutFeedback(PutFeedbackRequest putFeedbackRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putFeedbackRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutFeedbackRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutFeedbackRequestProtocolMarshaller(protocolFactory).marshall((PutFeedbackRequest)super.beforeMarshalling((AmazonWebServiceRequest)putFeedbackRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"DevOps Guru");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PutFeedback");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutFeedbackResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutFeedbackResult putFeedbackResult = (PutFeedbackResult)response.getAwsResponse();
            return putFeedbackResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public RemoveNotificationChannelResult removeNotificationChannel(RemoveNotificationChannelRequest request) {
        request = (RemoveNotificationChannelRequest)this.beforeClientExecution(request);
        return this.executeRemoveNotificationChannel(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final RemoveNotificationChannelResult executeRemoveNotificationChannel(RemoveNotificationChannelRequest removeNotificationChannelRequest) {
        ExecutionContext executionContext = this.createExecutionContext(removeNotificationChannelRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RemoveNotificationChannelRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RemoveNotificationChannelRequestProtocolMarshaller(protocolFactory).marshall((RemoveNotificationChannelRequest)super.beforeMarshalling((AmazonWebServiceRequest)removeNotificationChannelRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"DevOps Guru");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"RemoveNotificationChannel");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new RemoveNotificationChannelResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            RemoveNotificationChannelResult removeNotificationChannelResult = (RemoveNotificationChannelResult)response.getAwsResponse();
            return removeNotificationChannelResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public SearchInsightsResult searchInsights(SearchInsightsRequest request) {
        request = (SearchInsightsRequest)this.beforeClientExecution(request);
        return this.executeSearchInsights(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final SearchInsightsResult executeSearchInsights(SearchInsightsRequest searchInsightsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(searchInsightsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<SearchInsightsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new SearchInsightsRequestProtocolMarshaller(protocolFactory).marshall((SearchInsightsRequest)super.beforeMarshalling((AmazonWebServiceRequest)searchInsightsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"DevOps Guru");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"SearchInsights");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new SearchInsightsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            SearchInsightsResult searchInsightsResult = (SearchInsightsResult)response.getAwsResponse();
            return searchInsightsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public SearchOrganizationInsightsResult searchOrganizationInsights(SearchOrganizationInsightsRequest request) {
        request = (SearchOrganizationInsightsRequest)this.beforeClientExecution(request);
        return this.executeSearchOrganizationInsights(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final SearchOrganizationInsightsResult executeSearchOrganizationInsights(SearchOrganizationInsightsRequest searchOrganizationInsightsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(searchOrganizationInsightsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<SearchOrganizationInsightsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new SearchOrganizationInsightsRequestProtocolMarshaller(protocolFactory).marshall((SearchOrganizationInsightsRequest)super.beforeMarshalling((AmazonWebServiceRequest)searchOrganizationInsightsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"DevOps Guru");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"SearchOrganizationInsights");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new SearchOrganizationInsightsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            SearchOrganizationInsightsResult searchOrganizationInsightsResult = (SearchOrganizationInsightsResult)response.getAwsResponse();
            return searchOrganizationInsightsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StartCostEstimationResult startCostEstimation(StartCostEstimationRequest request) {
        request = (StartCostEstimationRequest)this.beforeClientExecution(request);
        return this.executeStartCostEstimation(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartCostEstimationResult executeStartCostEstimation(StartCostEstimationRequest startCostEstimationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startCostEstimationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartCostEstimationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartCostEstimationRequestProtocolMarshaller(protocolFactory).marshall((StartCostEstimationRequest)super.beforeMarshalling((AmazonWebServiceRequest)startCostEstimationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"DevOps Guru");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StartCostEstimation");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartCostEstimationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartCostEstimationResult startCostEstimationResult = (StartCostEstimationResult)response.getAwsResponse();
            return startCostEstimationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateEventSourcesConfigResult updateEventSourcesConfig(UpdateEventSourcesConfigRequest request) {
        request = (UpdateEventSourcesConfigRequest)this.beforeClientExecution(request);
        return this.executeUpdateEventSourcesConfig(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateEventSourcesConfigResult executeUpdateEventSourcesConfig(UpdateEventSourcesConfigRequest updateEventSourcesConfigRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateEventSourcesConfigRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateEventSourcesConfigRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateEventSourcesConfigRequestProtocolMarshaller(protocolFactory).marshall((UpdateEventSourcesConfigRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateEventSourcesConfigRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"DevOps Guru");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateEventSourcesConfig");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateEventSourcesConfigResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateEventSourcesConfigResult updateEventSourcesConfigResult = (UpdateEventSourcesConfigResult)response.getAwsResponse();
            return updateEventSourcesConfigResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateResourceCollectionResult updateResourceCollection(UpdateResourceCollectionRequest request) {
        request = (UpdateResourceCollectionRequest)this.beforeClientExecution(request);
        return this.executeUpdateResourceCollection(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateResourceCollectionResult executeUpdateResourceCollection(UpdateResourceCollectionRequest updateResourceCollectionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateResourceCollectionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateResourceCollectionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateResourceCollectionRequestProtocolMarshaller(protocolFactory).marshall((UpdateResourceCollectionRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateResourceCollectionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"DevOps Guru");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateResourceCollection");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateResourceCollectionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateResourceCollectionResult updateResourceCollectionResult = (UpdateResourceCollectionResult)response.getAwsResponse();
            return updateResourceCollectionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateServiceIntegrationResult updateServiceIntegration(UpdateServiceIntegrationRequest request) {
        request = (UpdateServiceIntegrationRequest)this.beforeClientExecution(request);
        return this.executeUpdateServiceIntegration(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateServiceIntegrationResult executeUpdateServiceIntegration(UpdateServiceIntegrationRequest updateServiceIntegrationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateServiceIntegrationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateServiceIntegrationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateServiceIntegrationRequestProtocolMarshaller(protocolFactory).marshall((UpdateServiceIntegrationRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateServiceIntegrationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"DevOps Guru");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateServiceIntegration");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateServiceIntegrationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateServiceIntegrationResult updateServiceIntegrationResult = (UpdateServiceIntegrationResult)response.getAwsResponse();
            return updateServiceIntegrationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

