/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.devopsguru.model.transform;

import java.util.List;
import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.devopsguru.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * DescribeOrganizationOverviewRequestMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class DescribeOrganizationOverviewRequestMarshaller {

    private static final MarshallingInfo<java.util.Date> FROMTIME_BINDING = MarshallingInfo.builder(MarshallingType.DATE)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FromTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<java.util.Date> TOTIME_BINDING = MarshallingInfo.builder(MarshallingType.DATE)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ToTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<List> ACCOUNTIDS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("AccountIds").build();
    private static final MarshallingInfo<List> ORGANIZATIONALUNITIDS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OrganizationalUnitIds").build();

    private static final DescribeOrganizationOverviewRequestMarshaller instance = new DescribeOrganizationOverviewRequestMarshaller();

    public static DescribeOrganizationOverviewRequestMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(DescribeOrganizationOverviewRequest describeOrganizationOverviewRequest, ProtocolMarshaller protocolMarshaller) {

        if (describeOrganizationOverviewRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(describeOrganizationOverviewRequest.getFromTime(), FROMTIME_BINDING);
            protocolMarshaller.marshall(describeOrganizationOverviewRequest.getToTime(), TOTIME_BINDING);
            protocolMarshaller.marshall(describeOrganizationOverviewRequest.getAccountIds(), ACCOUNTIDS_BINDING);
            protocolMarshaller.marshall(describeOrganizationOverviewRequest.getOrganizationalUnitIds(), ORGANIZATIONALUNITIDS_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
