/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.directconnect.model.transform;

import java.math.*;

import javax.annotation.Generated;

import com.amazonaws.services.directconnect.model.*;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers.*;
import com.amazonaws.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * MacSecKey JSON Unmarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class MacSecKeyJsonUnmarshaller implements Unmarshaller<MacSecKey, JsonUnmarshallerContext> {

    public MacSecKey unmarshall(JsonUnmarshallerContext context) throws Exception {
        MacSecKey macSecKey = new MacSecKey();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        boolean knownMember;

        while (true) {
            if (token == null)
                break;

            knownMember = false;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("secretARN", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    macSecKey.setSecretARN(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("ckn", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    macSecKey.setCkn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("state", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    macSecKey.setState(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("startOn", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    macSecKey.setStartOn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (token == FIELD_NAME && !knownMember) {
                    context.nextToken();
                    com.amazonaws.transform.UnknownMemberJsonUnmarshaller.getInstance().unmarshall(context);
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return macSecKey;
    }

    private static MacSecKeyJsonUnmarshaller instance;

    public static MacSecKeyJsonUnmarshaller getInstance() {
        if (instance == null)
            instance = new MacSecKeyJsonUnmarshaller();
        return instance;
    }
}
