/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directory.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.directory.model.Snapshot;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DescribeSnapshotsResult
implements Serializable,
Cloneable {
    private ListWithAutoConstructFlag<Snapshot> snapshots;
    private String nextToken;

    public List<Snapshot> getSnapshots() {
        if (this.snapshots == null) {
            this.snapshots = new ListWithAutoConstructFlag();
            this.snapshots.setAutoConstruct(true);
        }
        return this.snapshots;
    }

    public void setSnapshots(Collection<Snapshot> snapshots) {
        if (snapshots == null) {
            this.snapshots = null;
            return;
        }
        ListWithAutoConstructFlag snapshotsCopy = new ListWithAutoConstructFlag(snapshots.size());
        snapshotsCopy.addAll(snapshots);
        this.snapshots = snapshotsCopy;
    }

    public DescribeSnapshotsResult withSnapshots(Snapshot ... snapshots) {
        if (this.getSnapshots() == null) {
            this.setSnapshots(new ArrayList<Snapshot>(snapshots.length));
        }
        for (Snapshot value : snapshots) {
            this.getSnapshots().add(value);
        }
        return this;
    }

    public DescribeSnapshotsResult withSnapshots(Collection<Snapshot> snapshots) {
        if (snapshots == null) {
            this.snapshots = null;
        } else {
            ListWithAutoConstructFlag snapshotsCopy = new ListWithAutoConstructFlag(snapshots.size());
            snapshotsCopy.addAll(snapshots);
            this.snapshots = snapshotsCopy;
        }
        return this;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public DescribeSnapshotsResult withNextToken(String nextToken) {
        this.nextToken = nextToken;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSnapshots() != null) {
            sb.append("Snapshots: " + this.getSnapshots() + ",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: " + this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSnapshots() == null ? 0 : this.getSnapshots().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSnapshotsResult)) {
            return false;
        }
        DescribeSnapshotsResult other = (DescribeSnapshotsResult)obj;
        if (other.getSnapshots() == null ^ this.getSnapshots() == null) {
            return false;
        }
        if (other.getSnapshots() != null && !other.getSnapshots().equals(this.getSnapshots())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public DescribeSnapshotsResult clone() {
        try {
            return (DescribeSnapshotsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

