/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directory.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.directory.model.CreateMicrosoftADRequest;
import com.amazonaws.services.directory.model.transform.DirectoryVpcSettingsJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class CreateMicrosoftADRequestMarshaller
implements Marshaller<Request<CreateMicrosoftADRequest>, CreateMicrosoftADRequest> {
    public Request<CreateMicrosoftADRequest> marshall(CreateMicrosoftADRequest createMicrosoftADRequest) {
        if (createMicrosoftADRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createMicrosoftADRequest, "AWSDirectoryService");
        request.addHeader("X-Amz-Target", "DirectoryService_20150416.CreateMicrosoftAD");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (createMicrosoftADRequest.getName() != null) {
                jsonWriter.key("Name").value((Object)createMicrosoftADRequest.getName());
            }
            if (createMicrosoftADRequest.getShortName() != null) {
                jsonWriter.key("ShortName").value((Object)createMicrosoftADRequest.getShortName());
            }
            if (createMicrosoftADRequest.getPassword() != null) {
                jsonWriter.key("Password").value((Object)createMicrosoftADRequest.getPassword());
            }
            if (createMicrosoftADRequest.getDescription() != null) {
                jsonWriter.key("Description").value((Object)createMicrosoftADRequest.getDescription());
            }
            if (createMicrosoftADRequest.getVpcSettings() != null) {
                jsonWriter.key("VpcSettings");
                DirectoryVpcSettingsJsonMarshaller.getInstance().marshall(createMicrosoftADRequest.getVpcSettings(), jsonWriter);
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

