/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directory.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.directory.model.CreateDirectoryRequest;
import com.amazonaws.services.directory.model.transform.DirectoryVpcSettingsJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class CreateDirectoryRequestMarshaller
implements Marshaller<Request<CreateDirectoryRequest>, CreateDirectoryRequest> {
    public Request<CreateDirectoryRequest> marshall(CreateDirectoryRequest createDirectoryRequest) {
        if (createDirectoryRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createDirectoryRequest, "AWSDirectoryService");
        request.addHeader("X-Amz-Target", "DirectoryService_20150416.CreateDirectory");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (createDirectoryRequest.getName() != null) {
                jsonWriter.key("Name").value((Object)createDirectoryRequest.getName());
            }
            if (createDirectoryRequest.getShortName() != null) {
                jsonWriter.key("ShortName").value((Object)createDirectoryRequest.getShortName());
            }
            if (createDirectoryRequest.getPassword() != null) {
                jsonWriter.key("Password").value((Object)createDirectoryRequest.getPassword());
            }
            if (createDirectoryRequest.getDescription() != null) {
                jsonWriter.key("Description").value((Object)createDirectoryRequest.getDescription());
            }
            if (createDirectoryRequest.getSize() != null) {
                jsonWriter.key("Size").value((Object)createDirectoryRequest.getSize());
            }
            if (createDirectoryRequest.getVpcSettings() != null) {
                jsonWriter.key("VpcSettings");
                DirectoryVpcSettingsJsonMarshaller.getInstance().marshall(createDirectoryRequest.getVpcSettings(), jsonWriter);
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

