/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directory.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.directory.model.DescribeDirectoriesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class DescribeDirectoriesRequestMarshaller
implements Marshaller<Request<DescribeDirectoriesRequest>, DescribeDirectoriesRequest> {
    public Request<DescribeDirectoriesRequest> marshall(DescribeDirectoriesRequest describeDirectoriesRequest) {
        if (describeDirectoriesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeDirectoriesRequest, "AWSDirectoryService");
        request.addHeader("X-Amz-Target", "DirectoryService_20150416.DescribeDirectories");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            SdkInternalList directoryIdsList = (SdkInternalList)describeDirectoriesRequest.getDirectoryIds();
            if (!directoryIdsList.isEmpty() || !directoryIdsList.isAutoConstruct()) {
                jsonWriter.key("DirectoryIds");
                jsonWriter.array();
                for (String directoryIdsListValue : directoryIdsList) {
                    if (directoryIdsListValue == null) continue;
                    jsonWriter.value((Object)directoryIdsListValue);
                }
                jsonWriter.endArray();
            }
            if (describeDirectoriesRequest.getNextToken() != null) {
                jsonWriter.key("NextToken").value((Object)describeDirectoriesRequest.getNextToken());
            }
            if (describeDirectoriesRequest.getLimit() != null) {
                jsonWriter.key("Limit").value((Object)describeDirectoriesRequest.getLimit());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

