/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directory.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.directory.model.DescribeEventTopicsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class DescribeEventTopicsRequestMarshaller
implements Marshaller<Request<DescribeEventTopicsRequest>, DescribeEventTopicsRequest> {
    public Request<DescribeEventTopicsRequest> marshall(DescribeEventTopicsRequest describeEventTopicsRequest) {
        if (describeEventTopicsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeEventTopicsRequest, "AWSDirectoryService");
        request.addHeader("X-Amz-Target", "DirectoryService_20150416.DescribeEventTopics");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList topicNamesList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (describeEventTopicsRequest.getDirectoryId() != null) {
                jsonWriter.key("DirectoryId").value((Object)describeEventTopicsRequest.getDirectoryId());
            }
            if (!(topicNamesList = (SdkInternalList)describeEventTopicsRequest.getTopicNames()).isEmpty() || !topicNamesList.isAutoConstruct()) {
                jsonWriter.key("TopicNames");
                jsonWriter.array();
                for (String topicNamesListValue : topicNamesList) {
                    if (topicNamesListValue == null) continue;
                    jsonWriter.value((Object)topicNamesListValue);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

