/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directory.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.directory.model.DescribeTrustsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class DescribeTrustsRequestMarshaller
implements Marshaller<Request<DescribeTrustsRequest>, DescribeTrustsRequest> {
    public Request<DescribeTrustsRequest> marshall(DescribeTrustsRequest describeTrustsRequest) {
        if (describeTrustsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeTrustsRequest, "AWSDirectoryService");
        request.addHeader("X-Amz-Target", "DirectoryService_20150416.DescribeTrusts");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList trustIdsList;
            SdkJsonGenerator jsonGenerator = new SdkJsonGenerator();
            jsonGenerator.writeStartObject();
            if (describeTrustsRequest.getDirectoryId() != null) {
                jsonGenerator.writeFieldName("DirectoryId").writeValue(describeTrustsRequest.getDirectoryId());
            }
            if (!(trustIdsList = (SdkInternalList)describeTrustsRequest.getTrustIds()).isEmpty() || !trustIdsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("TrustIds");
                jsonGenerator.writeStartArray();
                for (String trustIdsListValue : trustIdsList) {
                    if (trustIdsListValue == null) continue;
                    jsonGenerator.writeValue(trustIdsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (describeTrustsRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("NextToken").writeValue(describeTrustsRequest.getNextToken());
            }
            if (describeTrustsRequest.getLimit() != null) {
                jsonGenerator.writeFieldName("Limit").writeValue((long)describeTrustsRequest.getLimit().intValue());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

