/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directory.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.directory.model.DirectoryDescription;
import com.amazonaws.services.directory.model.transform.DirectoryConnectSettingsDescriptionJsonMarshaller;
import com.amazonaws.services.directory.model.transform.DirectoryVpcSettingsDescriptionJsonMarshaller;
import com.amazonaws.services.directory.model.transform.RadiusSettingsJsonMarshaller;
import com.amazonaws.util.json.SdkJsonGenerator;

public class DirectoryDescriptionJsonMarshaller {
    private static DirectoryDescriptionJsonMarshaller instance;

    public void marshall(DirectoryDescription directoryDescription, SdkJsonGenerator jsonGenerator) {
        if (directoryDescription == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList dnsIpAddrsList;
            jsonGenerator.writeStartObject();
            if (directoryDescription.getDirectoryId() != null) {
                jsonGenerator.writeFieldName("DirectoryId").writeValue(directoryDescription.getDirectoryId());
            }
            if (directoryDescription.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(directoryDescription.getName());
            }
            if (directoryDescription.getShortName() != null) {
                jsonGenerator.writeFieldName("ShortName").writeValue(directoryDescription.getShortName());
            }
            if (directoryDescription.getSize() != null) {
                jsonGenerator.writeFieldName("Size").writeValue(directoryDescription.getSize());
            }
            if (directoryDescription.getAlias() != null) {
                jsonGenerator.writeFieldName("Alias").writeValue(directoryDescription.getAlias());
            }
            if (directoryDescription.getAccessUrl() != null) {
                jsonGenerator.writeFieldName("AccessUrl").writeValue(directoryDescription.getAccessUrl());
            }
            if (directoryDescription.getDescription() != null) {
                jsonGenerator.writeFieldName("Description").writeValue(directoryDescription.getDescription());
            }
            if (!(dnsIpAddrsList = (SdkInternalList)directoryDescription.getDnsIpAddrs()).isEmpty() || !dnsIpAddrsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("DnsIpAddrs");
                jsonGenerator.writeStartArray();
                for (String dnsIpAddrsListValue : dnsIpAddrsList) {
                    if (dnsIpAddrsListValue == null) continue;
                    jsonGenerator.writeValue(dnsIpAddrsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (directoryDescription.getStage() != null) {
                jsonGenerator.writeFieldName("Stage").writeValue(directoryDescription.getStage());
            }
            if (directoryDescription.getLaunchTime() != null) {
                jsonGenerator.writeFieldName("LaunchTime").writeValue(directoryDescription.getLaunchTime());
            }
            if (directoryDescription.getStageLastUpdatedDateTime() != null) {
                jsonGenerator.writeFieldName("StageLastUpdatedDateTime").writeValue(directoryDescription.getStageLastUpdatedDateTime());
            }
            if (directoryDescription.getType() != null) {
                jsonGenerator.writeFieldName("Type").writeValue(directoryDescription.getType());
            }
            if (directoryDescription.getVpcSettings() != null) {
                jsonGenerator.writeFieldName("VpcSettings");
                DirectoryVpcSettingsDescriptionJsonMarshaller.getInstance().marshall(directoryDescription.getVpcSettings(), jsonGenerator);
            }
            if (directoryDescription.getConnectSettings() != null) {
                jsonGenerator.writeFieldName("ConnectSettings");
                DirectoryConnectSettingsDescriptionJsonMarshaller.getInstance().marshall(directoryDescription.getConnectSettings(), jsonGenerator);
            }
            if (directoryDescription.getRadiusSettings() != null) {
                jsonGenerator.writeFieldName("RadiusSettings");
                RadiusSettingsJsonMarshaller.getInstance().marshall(directoryDescription.getRadiusSettings(), jsonGenerator);
            }
            if (directoryDescription.getRadiusStatus() != null) {
                jsonGenerator.writeFieldName("RadiusStatus").writeValue(directoryDescription.getRadiusStatus());
            }
            if (directoryDescription.getStageReason() != null) {
                jsonGenerator.writeFieldName("StageReason").writeValue(directoryDescription.getStageReason());
            }
            if (directoryDescription.getSsoEnabled() != null) {
                jsonGenerator.writeFieldName("SsoEnabled").writeValue(directoryDescription.getSsoEnabled().booleanValue());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static DirectoryDescriptionJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new DirectoryDescriptionJsonMarshaller();
        }
        return instance;
    }
}

