/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directory.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.directory.model.Attribute;
import com.amazonaws.services.directory.model.Computer;
import com.amazonaws.services.directory.model.transform.AttributeJsonMarshaller;
import com.amazonaws.util.json.SdkJsonGenerator;

public class ComputerJsonMarshaller {
    private static ComputerJsonMarshaller instance;

    public void marshall(Computer computer, SdkJsonGenerator jsonGenerator) {
        if (computer == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList computerAttributesList;
            jsonGenerator.writeStartObject();
            if (computer.getComputerId() != null) {
                jsonGenerator.writeFieldName("ComputerId").writeValue(computer.getComputerId());
            }
            if (computer.getComputerName() != null) {
                jsonGenerator.writeFieldName("ComputerName").writeValue(computer.getComputerName());
            }
            if (!(computerAttributesList = (SdkInternalList)computer.getComputerAttributes()).isEmpty() || !computerAttributesList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("ComputerAttributes");
                jsonGenerator.writeStartArray();
                for (Attribute computerAttributesListValue : computerAttributesList) {
                    if (computerAttributesListValue == null) continue;
                    AttributeJsonMarshaller.getInstance().marshall(computerAttributesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ComputerJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ComputerJsonMarshaller();
        }
        return instance;
    }
}

