/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directory.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.directory.model.DescribeEventTopicsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class DescribeEventTopicsRequestMarshaller
implements Marshaller<Request<DescribeEventTopicsRequest>, DescribeEventTopicsRequest> {
    public Request<DescribeEventTopicsRequest> marshall(DescribeEventTopicsRequest describeEventTopicsRequest) {
        if (describeEventTopicsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeEventTopicsRequest, "AWSDirectoryService");
        request.addHeader("X-Amz-Target", "DirectoryService_20150416.DescribeEventTopics");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList topicNamesList;
            SdkJsonGenerator jsonGenerator = new SdkJsonGenerator();
            jsonGenerator.writeStartObject();
            if (describeEventTopicsRequest.getDirectoryId() != null) {
                jsonGenerator.writeFieldName("DirectoryId").writeValue(describeEventTopicsRequest.getDirectoryId());
            }
            if (!(topicNamesList = (SdkInternalList)describeEventTopicsRequest.getTopicNames()).isEmpty() || !topicNamesList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("TopicNames");
                jsonGenerator.writeStartArray();
                for (String topicNamesListValue : topicNamesList) {
                    if (topicNamesListValue == null) continue;
                    jsonGenerator.writeValue(topicNamesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

