/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directory.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.directory.model.CreateTrustRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class CreateTrustRequestMarshaller
implements Marshaller<Request<CreateTrustRequest>, CreateTrustRequest> {
    public Request<CreateTrustRequest> marshall(CreateTrustRequest createTrustRequest) {
        if (createTrustRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createTrustRequest, "AWSDirectoryService");
        request.addHeader("X-Amz-Target", "DirectoryService_20150416.CreateTrust");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter((boolean)false, (String)"1.1");
            jsonGenerator.writeStartObject();
            if (createTrustRequest.getDirectoryId() != null) {
                jsonGenerator.writeFieldName("DirectoryId").writeValue(createTrustRequest.getDirectoryId());
            }
            if (createTrustRequest.getRemoteDomainName() != null) {
                jsonGenerator.writeFieldName("RemoteDomainName").writeValue(createTrustRequest.getRemoteDomainName());
            }
            if (createTrustRequest.getTrustPassword() != null) {
                jsonGenerator.writeFieldName("TrustPassword").writeValue(createTrustRequest.getTrustPassword());
            }
            if (createTrustRequest.getTrustDirection() != null) {
                jsonGenerator.writeFieldName("TrustDirection").writeValue(createTrustRequest.getTrustDirection());
            }
            if (createTrustRequest.getTrustType() != null) {
                jsonGenerator.writeFieldName("TrustType").writeValue(createTrustRequest.getTrustType());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

