/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directory.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.directory.model.RadiusSettings;
import com.amazonaws.util.json.StructuredJsonGenerator;

public class RadiusSettingsJsonMarshaller {
    private static RadiusSettingsJsonMarshaller instance;

    public void marshall(RadiusSettings radiusSettings, StructuredJsonGenerator jsonGenerator) {
        if (radiusSettings == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            SdkInternalList radiusServersList = (SdkInternalList)radiusSettings.getRadiusServers();
            if (!radiusServersList.isEmpty() || !radiusServersList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("RadiusServers");
                jsonGenerator.writeStartArray();
                for (String radiusServersListValue : radiusServersList) {
                    if (radiusServersListValue == null) continue;
                    jsonGenerator.writeValue(radiusServersListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (radiusSettings.getRadiusPort() != null) {
                jsonGenerator.writeFieldName("RadiusPort").writeValue(radiusSettings.getRadiusPort().intValue());
            }
            if (radiusSettings.getRadiusTimeout() != null) {
                jsonGenerator.writeFieldName("RadiusTimeout").writeValue(radiusSettings.getRadiusTimeout().intValue());
            }
            if (radiusSettings.getRadiusRetries() != null) {
                jsonGenerator.writeFieldName("RadiusRetries").writeValue(radiusSettings.getRadiusRetries().intValue());
            }
            if (radiusSettings.getSharedSecret() != null) {
                jsonGenerator.writeFieldName("SharedSecret").writeValue(radiusSettings.getSharedSecret());
            }
            if (radiusSettings.getAuthenticationProtocol() != null) {
                jsonGenerator.writeFieldName("AuthenticationProtocol").writeValue(radiusSettings.getAuthenticationProtocol());
            }
            if (radiusSettings.getDisplayLabel() != null) {
                jsonGenerator.writeFieldName("DisplayLabel").writeValue(radiusSettings.getDisplayLabel());
            }
            if (radiusSettings.getUseSameUsername() != null) {
                jsonGenerator.writeFieldName("UseSameUsername").writeValue(radiusSettings.getUseSameUsername().booleanValue());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static RadiusSettingsJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new RadiusSettingsJsonMarshaller();
        }
        return instance;
    }
}

