/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directory.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.directory.model.RemoveIpRoutesRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class RemoveIpRoutesRequestMarshaller
implements Marshaller<Request<RemoveIpRoutesRequest>, RemoveIpRoutesRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public RemoveIpRoutesRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<RemoveIpRoutesRequest> marshall(RemoveIpRoutesRequest removeIpRoutesRequest) {
        if (removeIpRoutesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)removeIpRoutesRequest, "AWSDirectoryService");
        request.addHeader("X-Amz-Target", "DirectoryService_20150416.RemoveIpRoutes");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList cidrIpsList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (removeIpRoutesRequest.getDirectoryId() != null) {
                jsonGenerator.writeFieldName("DirectoryId").writeValue(removeIpRoutesRequest.getDirectoryId());
            }
            if (!(cidrIpsList = (SdkInternalList)removeIpRoutesRequest.getCidrIps()).isEmpty() || !cidrIpsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("CidrIps");
                jsonGenerator.writeStartArray();
                for (String cidrIpsListValue : cidrIpsList) {
                    if (cidrIpsListValue == null) continue;
                    jsonGenerator.writeValue(cidrIpsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

