/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directory.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.directory.model.DirectoryDescription;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class DirectoryDescriptionMarshaller {
    private static final MarshallingInfo<String> DIRECTORYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DirectoryId").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<String> SHORTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ShortName").build();
    private static final MarshallingInfo<String> SIZE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Size").build();
    private static final MarshallingInfo<String> EDITION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Edition").build();
    private static final MarshallingInfo<String> ALIAS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Alias").build();
    private static final MarshallingInfo<String> ACCESSURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AccessUrl").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").build();
    private static final MarshallingInfo<List> DNSIPADDRS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DnsIpAddrs").build();
    private static final MarshallingInfo<String> STAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Stage").build();
    private static final MarshallingInfo<String> SHARESTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ShareStatus").build();
    private static final MarshallingInfo<String> SHAREMETHOD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ShareMethod").build();
    private static final MarshallingInfo<String> SHARENOTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ShareNotes").build();
    private static final MarshallingInfo<Date> LAUNCHTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LaunchTime").build();
    private static final MarshallingInfo<Date> STAGELASTUPDATEDDATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StageLastUpdatedDateTime").build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Type").build();
    private static final MarshallingInfo<StructuredPojo> VPCSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VpcSettings").build();
    private static final MarshallingInfo<StructuredPojo> CONNECTSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConnectSettings").build();
    private static final MarshallingInfo<StructuredPojo> RADIUSSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RadiusSettings").build();
    private static final MarshallingInfo<String> RADIUSSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RadiusStatus").build();
    private static final MarshallingInfo<String> STAGEREASON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StageReason").build();
    private static final MarshallingInfo<Boolean> SSOENABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SsoEnabled").build();
    private static final MarshallingInfo<Integer> DESIREDNUMBEROFDOMAINCONTROLLERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DesiredNumberOfDomainControllers").build();
    private static final MarshallingInfo<StructuredPojo> OWNERDIRECTORYDESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OwnerDirectoryDescription").build();
    private static final DirectoryDescriptionMarshaller instance = new DirectoryDescriptionMarshaller();

    public static DirectoryDescriptionMarshaller getInstance() {
        return instance;
    }

    public void marshall(DirectoryDescription directoryDescription, ProtocolMarshaller protocolMarshaller) {
        if (directoryDescription == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)directoryDescription.getDirectoryId(), DIRECTORYID_BINDING);
            protocolMarshaller.marshall((Object)directoryDescription.getName(), NAME_BINDING);
            protocolMarshaller.marshall((Object)directoryDescription.getShortName(), SHORTNAME_BINDING);
            protocolMarshaller.marshall((Object)directoryDescription.getSize(), SIZE_BINDING);
            protocolMarshaller.marshall((Object)directoryDescription.getEdition(), EDITION_BINDING);
            protocolMarshaller.marshall((Object)directoryDescription.getAlias(), ALIAS_BINDING);
            protocolMarshaller.marshall((Object)directoryDescription.getAccessUrl(), ACCESSURL_BINDING);
            protocolMarshaller.marshall((Object)directoryDescription.getDescription(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall(directoryDescription.getDnsIpAddrs(), DNSIPADDRS_BINDING);
            protocolMarshaller.marshall((Object)directoryDescription.getStage(), STAGE_BINDING);
            protocolMarshaller.marshall((Object)directoryDescription.getShareStatus(), SHARESTATUS_BINDING);
            protocolMarshaller.marshall((Object)directoryDescription.getShareMethod(), SHAREMETHOD_BINDING);
            protocolMarshaller.marshall((Object)directoryDescription.getShareNotes(), SHARENOTES_BINDING);
            protocolMarshaller.marshall((Object)directoryDescription.getLaunchTime(), LAUNCHTIME_BINDING);
            protocolMarshaller.marshall((Object)directoryDescription.getStageLastUpdatedDateTime(), STAGELASTUPDATEDDATETIME_BINDING);
            protocolMarshaller.marshall((Object)directoryDescription.getType(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)directoryDescription.getVpcSettings(), VPCSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)directoryDescription.getConnectSettings(), CONNECTSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)directoryDescription.getRadiusSettings(), RADIUSSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)directoryDescription.getRadiusStatus(), RADIUSSTATUS_BINDING);
            protocolMarshaller.marshall((Object)directoryDescription.getStageReason(), STAGEREASON_BINDING);
            protocolMarshaller.marshall((Object)directoryDescription.getSsoEnabled(), SSOENABLED_BINDING);
            protocolMarshaller.marshall((Object)directoryDescription.getDesiredNumberOfDomainControllers(), DESIREDNUMBEROFDOMAINCONTROLLERS_BINDING);
            protocolMarshaller.marshall((Object)directoryDescription.getOwnerDirectoryDescription(), OWNERDIRECTORYDESCRIPTION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

