/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directory.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.directory.model.DescribeConditionalForwardersRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class DescribeConditionalForwardersRequestMarshaller
implements Marshaller<Request<DescribeConditionalForwardersRequest>, DescribeConditionalForwardersRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DescribeConditionalForwardersRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<DescribeConditionalForwardersRequest> marshall(DescribeConditionalForwardersRequest describeConditionalForwardersRequest) {
        if (describeConditionalForwardersRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeConditionalForwardersRequest, "AWSDirectoryService");
        request.addHeader("X-Amz-Target", "DirectoryService_20150416.DescribeConditionalForwarders");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList remoteDomainNamesList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (describeConditionalForwardersRequest.getDirectoryId() != null) {
                jsonGenerator.writeFieldName("DirectoryId").writeValue(describeConditionalForwardersRequest.getDirectoryId());
            }
            if (!(remoteDomainNamesList = (SdkInternalList)describeConditionalForwardersRequest.getRemoteDomainNames()).isEmpty() || !remoteDomainNamesList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("RemoteDomainNames");
                jsonGenerator.writeStartArray();
                for (String remoteDomainNamesListValue : remoteDomainNamesList) {
                    if (remoteDomainNamesListValue == null) continue;
                    jsonGenerator.writeValue(remoteDomainNamesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

