/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directory.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.directory.model.TrustDirection;
import com.amazonaws.services.directory.model.TrustType;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class CreateTrustRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String directoryId;
    private String remoteDomainName;
    private String trustPassword;
    private String trustDirection;
    private String trustType;
    private SdkInternalList<String> conditionalForwarderIpAddrs;

    public void setDirectoryId(String directoryId) {
        this.directoryId = directoryId;
    }

    public String getDirectoryId() {
        return this.directoryId;
    }

    public CreateTrustRequest withDirectoryId(String directoryId) {
        this.setDirectoryId(directoryId);
        return this;
    }

    public void setRemoteDomainName(String remoteDomainName) {
        this.remoteDomainName = remoteDomainName;
    }

    public String getRemoteDomainName() {
        return this.remoteDomainName;
    }

    public CreateTrustRequest withRemoteDomainName(String remoteDomainName) {
        this.setRemoteDomainName(remoteDomainName);
        return this;
    }

    public void setTrustPassword(String trustPassword) {
        this.trustPassword = trustPassword;
    }

    public String getTrustPassword() {
        return this.trustPassword;
    }

    public CreateTrustRequest withTrustPassword(String trustPassword) {
        this.setTrustPassword(trustPassword);
        return this;
    }

    public void setTrustDirection(String trustDirection) {
        this.trustDirection = trustDirection;
    }

    public String getTrustDirection() {
        return this.trustDirection;
    }

    public CreateTrustRequest withTrustDirection(String trustDirection) {
        this.setTrustDirection(trustDirection);
        return this;
    }

    public void setTrustDirection(TrustDirection trustDirection) {
        this.trustDirection = trustDirection.toString();
    }

    public CreateTrustRequest withTrustDirection(TrustDirection trustDirection) {
        this.setTrustDirection(trustDirection);
        return this;
    }

    public void setTrustType(String trustType) {
        this.trustType = trustType;
    }

    public String getTrustType() {
        return this.trustType;
    }

    public CreateTrustRequest withTrustType(String trustType) {
        this.setTrustType(trustType);
        return this;
    }

    public void setTrustType(TrustType trustType) {
        this.trustType = trustType.toString();
    }

    public CreateTrustRequest withTrustType(TrustType trustType) {
        this.setTrustType(trustType);
        return this;
    }

    public List<String> getConditionalForwarderIpAddrs() {
        if (this.conditionalForwarderIpAddrs == null) {
            this.conditionalForwarderIpAddrs = new SdkInternalList();
        }
        return this.conditionalForwarderIpAddrs;
    }

    public void setConditionalForwarderIpAddrs(Collection<String> conditionalForwarderIpAddrs) {
        if (conditionalForwarderIpAddrs == null) {
            this.conditionalForwarderIpAddrs = null;
            return;
        }
        this.conditionalForwarderIpAddrs = new SdkInternalList(conditionalForwarderIpAddrs);
    }

    public CreateTrustRequest withConditionalForwarderIpAddrs(String ... conditionalForwarderIpAddrs) {
        if (this.conditionalForwarderIpAddrs == null) {
            this.setConditionalForwarderIpAddrs((Collection<String>)new SdkInternalList(conditionalForwarderIpAddrs.length));
        }
        for (String ele : conditionalForwarderIpAddrs) {
            this.conditionalForwarderIpAddrs.add((Object)ele);
        }
        return this;
    }

    public CreateTrustRequest withConditionalForwarderIpAddrs(Collection<String> conditionalForwarderIpAddrs) {
        this.setConditionalForwarderIpAddrs(conditionalForwarderIpAddrs);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDirectoryId() != null) {
            sb.append("DirectoryId: " + this.getDirectoryId() + ",");
        }
        if (this.getRemoteDomainName() != null) {
            sb.append("RemoteDomainName: " + this.getRemoteDomainName() + ",");
        }
        if (this.getTrustPassword() != null) {
            sb.append("TrustPassword: " + this.getTrustPassword() + ",");
        }
        if (this.getTrustDirection() != null) {
            sb.append("TrustDirection: " + this.getTrustDirection() + ",");
        }
        if (this.getTrustType() != null) {
            sb.append("TrustType: " + this.getTrustType() + ",");
        }
        if (this.getConditionalForwarderIpAddrs() != null) {
            sb.append("ConditionalForwarderIpAddrs: " + this.getConditionalForwarderIpAddrs());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTrustRequest)) {
            return false;
        }
        CreateTrustRequest other = (CreateTrustRequest)obj;
        if (other.getDirectoryId() == null ^ this.getDirectoryId() == null) {
            return false;
        }
        if (other.getDirectoryId() != null && !other.getDirectoryId().equals(this.getDirectoryId())) {
            return false;
        }
        if (other.getRemoteDomainName() == null ^ this.getRemoteDomainName() == null) {
            return false;
        }
        if (other.getRemoteDomainName() != null && !other.getRemoteDomainName().equals(this.getRemoteDomainName())) {
            return false;
        }
        if (other.getTrustPassword() == null ^ this.getTrustPassword() == null) {
            return false;
        }
        if (other.getTrustPassword() != null && !other.getTrustPassword().equals(this.getTrustPassword())) {
            return false;
        }
        if (other.getTrustDirection() == null ^ this.getTrustDirection() == null) {
            return false;
        }
        if (other.getTrustDirection() != null && !other.getTrustDirection().equals(this.getTrustDirection())) {
            return false;
        }
        if (other.getTrustType() == null ^ this.getTrustType() == null) {
            return false;
        }
        if (other.getTrustType() != null && !other.getTrustType().equals(this.getTrustType())) {
            return false;
        }
        if (other.getConditionalForwarderIpAddrs() == null ^ this.getConditionalForwarderIpAddrs() == null) {
            return false;
        }
        return other.getConditionalForwarderIpAddrs() == null || other.getConditionalForwarderIpAddrs().equals(this.getConditionalForwarderIpAddrs());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDirectoryId() == null ? 0 : this.getDirectoryId().hashCode());
        hashCode = 31 * hashCode + (this.getRemoteDomainName() == null ? 0 : this.getRemoteDomainName().hashCode());
        hashCode = 31 * hashCode + (this.getTrustPassword() == null ? 0 : this.getTrustPassword().hashCode());
        hashCode = 31 * hashCode + (this.getTrustDirection() == null ? 0 : this.getTrustDirection().hashCode());
        hashCode = 31 * hashCode + (this.getTrustType() == null ? 0 : this.getTrustType().hashCode());
        hashCode = 31 * hashCode + (this.getConditionalForwarderIpAddrs() == null ? 0 : this.getConditionalForwarderIpAddrs().hashCode());
        return hashCode;
    }

    public CreateTrustRequest clone() {
        return (CreateTrustRequest)super.clone();
    }
}

