/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directory.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.directory.model.ListSchemaExtensionsRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class ListSchemaExtensionsRequestMarshaller
implements Marshaller<Request<ListSchemaExtensionsRequest>, ListSchemaExtensionsRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public ListSchemaExtensionsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<ListSchemaExtensionsRequest> marshall(ListSchemaExtensionsRequest listSchemaExtensionsRequest) {
        if (listSchemaExtensionsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listSchemaExtensionsRequest, "AWSDirectoryService");
        request.addHeader("X-Amz-Target", "DirectoryService_20150416.ListSchemaExtensions");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (listSchemaExtensionsRequest.getDirectoryId() != null) {
                jsonGenerator.writeFieldName("DirectoryId").writeValue(listSchemaExtensionsRequest.getDirectoryId());
            }
            if (listSchemaExtensionsRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("NextToken").writeValue(listSchemaExtensionsRequest.getNextToken());
            }
            if (listSchemaExtensionsRequest.getLimit() != null) {
                jsonGenerator.writeFieldName("Limit").writeValue(listSchemaExtensionsRequest.getLimit().intValue());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

