/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directory.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.directory.model.Attribute;
import com.amazonaws.services.directory.model.CreateComputerRequest;
import com.amazonaws.services.directory.model.transform.AttributeJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class CreateComputerRequestMarshaller
implements Marshaller<Request<CreateComputerRequest>, CreateComputerRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public CreateComputerRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<CreateComputerRequest> marshall(CreateComputerRequest createComputerRequest) {
        if (createComputerRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createComputerRequest, "AWSDirectoryService");
        request.addHeader("X-Amz-Target", "DirectoryService_20150416.CreateComputer");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList computerAttributesList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createComputerRequest.getDirectoryId() != null) {
                jsonGenerator.writeFieldName("DirectoryId").writeValue(createComputerRequest.getDirectoryId());
            }
            if (createComputerRequest.getComputerName() != null) {
                jsonGenerator.writeFieldName("ComputerName").writeValue(createComputerRequest.getComputerName());
            }
            if (createComputerRequest.getPassword() != null) {
                jsonGenerator.writeFieldName("Password").writeValue(createComputerRequest.getPassword());
            }
            if (createComputerRequest.getOrganizationalUnitDistinguishedName() != null) {
                jsonGenerator.writeFieldName("OrganizationalUnitDistinguishedName").writeValue(createComputerRequest.getOrganizationalUnitDistinguishedName());
            }
            if (!(computerAttributesList = (SdkInternalList)createComputerRequest.getComputerAttributes()).isEmpty() || !computerAttributesList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("ComputerAttributes");
                jsonGenerator.writeStartArray();
                for (Attribute computerAttributesListValue : computerAttributesList) {
                    if (computerAttributesListValue == null) continue;
                    AttributeJsonMarshaller.getInstance().marshall(computerAttributesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

