/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directory.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.directory.model.CreateMicrosoftADRequest;
import com.amazonaws.services.directory.model.transform.DirectoryVpcSettingsJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class CreateMicrosoftADRequestMarshaller
implements Marshaller<Request<CreateMicrosoftADRequest>, CreateMicrosoftADRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public CreateMicrosoftADRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<CreateMicrosoftADRequest> marshall(CreateMicrosoftADRequest createMicrosoftADRequest) {
        if (createMicrosoftADRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createMicrosoftADRequest, "AWSDirectoryService");
        request.addHeader("X-Amz-Target", "DirectoryService_20150416.CreateMicrosoftAD");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createMicrosoftADRequest.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(createMicrosoftADRequest.getName());
            }
            if (createMicrosoftADRequest.getShortName() != null) {
                jsonGenerator.writeFieldName("ShortName").writeValue(createMicrosoftADRequest.getShortName());
            }
            if (createMicrosoftADRequest.getPassword() != null) {
                jsonGenerator.writeFieldName("Password").writeValue(createMicrosoftADRequest.getPassword());
            }
            if (createMicrosoftADRequest.getDescription() != null) {
                jsonGenerator.writeFieldName("Description").writeValue(createMicrosoftADRequest.getDescription());
            }
            if (createMicrosoftADRequest.getVpcSettings() != null) {
                jsonGenerator.writeFieldName("VpcSettings");
                DirectoryVpcSettingsJsonMarshaller.getInstance().marshall(createMicrosoftADRequest.getVpcSettings(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

