/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directory.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.directory.model.EventTopic;
import java.util.Date;

@SdkInternalApi
public class EventTopicMarshaller {
    private static final MarshallingInfo<String> DIRECTORYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DirectoryId").build();
    private static final MarshallingInfo<String> TOPICNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TopicName").build();
    private static final MarshallingInfo<String> TOPICARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TopicArn").build();
    private static final MarshallingInfo<Date> CREATEDDATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedDateTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").build();
    private static final EventTopicMarshaller instance = new EventTopicMarshaller();

    public static EventTopicMarshaller getInstance() {
        return instance;
    }

    public void marshall(EventTopic eventTopic, ProtocolMarshaller protocolMarshaller) {
        if (eventTopic == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)eventTopic.getDirectoryId(), DIRECTORYID_BINDING);
            protocolMarshaller.marshall((Object)eventTopic.getTopicName(), TOPICNAME_BINDING);
            protocolMarshaller.marshall((Object)eventTopic.getTopicArn(), TOPICARN_BINDING);
            protocolMarshaller.marshall((Object)eventTopic.getCreatedDateTime(), CREATEDDATETIME_BINDING);
            protocolMarshaller.marshall((Object)eventTopic.getStatus(), STATUS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

