/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.applicationdiscovery.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.applicationdiscovery.model.DisassociateConfigurationItemsFromApplicationRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;

public class DisassociateConfigurationItemsFromApplicationRequestMarshaller
implements Marshaller<Request<DisassociateConfigurationItemsFromApplicationRequest>, DisassociateConfigurationItemsFromApplicationRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DisassociateConfigurationItemsFromApplicationRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<DisassociateConfigurationItemsFromApplicationRequest> marshall(DisassociateConfigurationItemsFromApplicationRequest disassociateConfigurationItemsFromApplicationRequest) {
        if (disassociateConfigurationItemsFromApplicationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)disassociateConfigurationItemsFromApplicationRequest, "AWSApplicationDiscovery");
        request.addHeader("X-Amz-Target", "AWSPoseidonService_V2015_11_01.DisassociateConfigurationItemsFromApplication");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<String> configurationIdsList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (disassociateConfigurationItemsFromApplicationRequest.getApplicationConfigurationId() != null) {
                jsonGenerator.writeFieldName("applicationConfigurationId").writeValue(disassociateConfigurationItemsFromApplicationRequest.getApplicationConfigurationId());
            }
            if ((configurationIdsList = disassociateConfigurationItemsFromApplicationRequest.getConfigurationIds()) != null) {
                jsonGenerator.writeFieldName("configurationIds");
                jsonGenerator.writeStartArray();
                for (String configurationIdsListValue : configurationIdsList) {
                    if (configurationIdsListValue == null) continue;
                    jsonGenerator.writeValue(configurationIdsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

