/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.applicationdiscovery.model;

import java.io.Serializable;
import javax.annotation.Generated;

@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class BatchDeleteAgentsResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * A list of agent IDs that failed to delete during the deletion task, each paired with an error message.
     * </p>
     */
    private java.util.List<BatchDeleteAgentError> errors;

    /**
     * <p>
     * A list of agent IDs that failed to delete during the deletion task, each paired with an error message.
     * </p>
     * 
     * @return A list of agent IDs that failed to delete during the deletion task, each paired with an error message.
     */

    public java.util.List<BatchDeleteAgentError> getErrors() {
        return errors;
    }

    /**
     * <p>
     * A list of agent IDs that failed to delete during the deletion task, each paired with an error message.
     * </p>
     * 
     * @param errors
     *        A list of agent IDs that failed to delete during the deletion task, each paired with an error message.
     */

    public void setErrors(java.util.Collection<BatchDeleteAgentError> errors) {
        if (errors == null) {
            this.errors = null;
            return;
        }

        this.errors = new java.util.ArrayList<BatchDeleteAgentError>(errors);
    }

    /**
     * <p>
     * A list of agent IDs that failed to delete during the deletion task, each paired with an error message.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setErrors(java.util.Collection)} or {@link #withErrors(java.util.Collection)} if you want to override the
     * existing values.
     * </p>
     * 
     * @param errors
     *        A list of agent IDs that failed to delete during the deletion task, each paired with an error message.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public BatchDeleteAgentsResult withErrors(BatchDeleteAgentError... errors) {
        if (this.errors == null) {
            setErrors(new java.util.ArrayList<BatchDeleteAgentError>(errors.length));
        }
        for (BatchDeleteAgentError ele : errors) {
            this.errors.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * A list of agent IDs that failed to delete during the deletion task, each paired with an error message.
     * </p>
     * 
     * @param errors
     *        A list of agent IDs that failed to delete during the deletion task, each paired with an error message.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public BatchDeleteAgentsResult withErrors(java.util.Collection<BatchDeleteAgentError> errors) {
        setErrors(errors);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getErrors() != null)
            sb.append("Errors: ").append(getErrors());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof BatchDeleteAgentsResult == false)
            return false;
        BatchDeleteAgentsResult other = (BatchDeleteAgentsResult) obj;
        if (other.getErrors() == null ^ this.getErrors() == null)
            return false;
        if (other.getErrors() != null && other.getErrors().equals(this.getErrors()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getErrors() == null) ? 0 : getErrors().hashCode());
        return hashCode;
    }

    @Override
    public BatchDeleteAgentsResult clone() {
        try {
            return (BatchDeleteAgentsResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
