/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.databasemigrationservice.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.databasemigrationservice.model.CreateEndpointRequest;
import com.amazonaws.services.databasemigrationservice.model.Tag;
import com.amazonaws.services.databasemigrationservice.model.transform.TagJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;

public class CreateEndpointRequestMarshaller
implements Marshaller<Request<CreateEndpointRequest>, CreateEndpointRequest> {
    public Request<CreateEndpointRequest> marshall(CreateEndpointRequest createEndpointRequest) {
        if (createEndpointRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createEndpointRequest, "AWSDatabaseMigrationService");
        request.addHeader("X-Amz-Target", "AmazonDMSv20160101.CreateEndpoint");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<Tag> tagsList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (createEndpointRequest.getEndpointIdentifier() != null) {
                jsonWriter.key("EndpointIdentifier").value((Object)createEndpointRequest.getEndpointIdentifier());
            }
            if (createEndpointRequest.getEndpointType() != null) {
                jsonWriter.key("EndpointType").value((Object)createEndpointRequest.getEndpointType());
            }
            if (createEndpointRequest.getEngineName() != null) {
                jsonWriter.key("EngineName").value((Object)createEndpointRequest.getEngineName());
            }
            if (createEndpointRequest.getUsername() != null) {
                jsonWriter.key("Username").value((Object)createEndpointRequest.getUsername());
            }
            if (createEndpointRequest.getPassword() != null) {
                jsonWriter.key("Password").value((Object)createEndpointRequest.getPassword());
            }
            if (createEndpointRequest.getServerName() != null) {
                jsonWriter.key("ServerName").value((Object)createEndpointRequest.getServerName());
            }
            if (createEndpointRequest.getPort() != null) {
                jsonWriter.key("Port").value((Object)createEndpointRequest.getPort());
            }
            if (createEndpointRequest.getDatabaseName() != null) {
                jsonWriter.key("DatabaseName").value((Object)createEndpointRequest.getDatabaseName());
            }
            if (createEndpointRequest.getExtraConnectionAttributes() != null) {
                jsonWriter.key("ExtraConnectionAttributes").value((Object)createEndpointRequest.getExtraConnectionAttributes());
            }
            if (createEndpointRequest.getKmsKeyId() != null) {
                jsonWriter.key("KmsKeyId").value((Object)createEndpointRequest.getKmsKeyId());
            }
            if ((tagsList = createEndpointRequest.getTags()) != null) {
                jsonWriter.key("Tags");
                jsonWriter.array();
                for (Tag tagsListValue : tagsList) {
                    if (tagsListValue == null) continue;
                    TagJsonMarshaller.getInstance().marshall(tagsListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

