/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.databasemigrationservice.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.databasemigrationservice.model.CreateReplicationInstanceRequest;
import com.amazonaws.services.databasemigrationservice.model.Tag;
import com.amazonaws.services.databasemigrationservice.model.transform.TagJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;

public class CreateReplicationInstanceRequestMarshaller
implements Marshaller<Request<CreateReplicationInstanceRequest>, CreateReplicationInstanceRequest> {
    public Request<CreateReplicationInstanceRequest> marshall(CreateReplicationInstanceRequest createReplicationInstanceRequest) {
        if (createReplicationInstanceRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createReplicationInstanceRequest, "AWSDatabaseMigrationService");
        request.addHeader("X-Amz-Target", "AmazonDMSv20160101.CreateReplicationInstance");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<Tag> tagsList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (createReplicationInstanceRequest.getReplicationInstanceIdentifier() != null) {
                jsonWriter.key("ReplicationInstanceIdentifier").value((Object)createReplicationInstanceRequest.getReplicationInstanceIdentifier());
            }
            if (createReplicationInstanceRequest.getAllocatedStorage() != null) {
                jsonWriter.key("AllocatedStorage").value((Object)createReplicationInstanceRequest.getAllocatedStorage());
            }
            if (createReplicationInstanceRequest.getReplicationInstanceClass() != null) {
                jsonWriter.key("ReplicationInstanceClass").value((Object)createReplicationInstanceRequest.getReplicationInstanceClass());
            }
            if (createReplicationInstanceRequest.getAvailabilityZone() != null) {
                jsonWriter.key("AvailabilityZone").value((Object)createReplicationInstanceRequest.getAvailabilityZone());
            }
            if (createReplicationInstanceRequest.getReplicationSubnetGroupIdentifier() != null) {
                jsonWriter.key("ReplicationSubnetGroupIdentifier").value((Object)createReplicationInstanceRequest.getReplicationSubnetGroupIdentifier());
            }
            if (createReplicationInstanceRequest.getPreferredMaintenanceWindow() != null) {
                jsonWriter.key("PreferredMaintenanceWindow").value((Object)createReplicationInstanceRequest.getPreferredMaintenanceWindow());
            }
            if (createReplicationInstanceRequest.getEngineVersion() != null) {
                jsonWriter.key("EngineVersion").value((Object)createReplicationInstanceRequest.getEngineVersion());
            }
            if (createReplicationInstanceRequest.getAutoMinorVersionUpgrade() != null) {
                jsonWriter.key("AutoMinorVersionUpgrade").value((Object)createReplicationInstanceRequest.getAutoMinorVersionUpgrade());
            }
            if ((tagsList = createReplicationInstanceRequest.getTags()) != null) {
                jsonWriter.key("Tags");
                jsonWriter.array();
                for (Tag tagsListValue : tagsList) {
                    if (tagsListValue == null) continue;
                    TagJsonMarshaller.getInstance().marshall(tagsListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (createReplicationInstanceRequest.getKmsKeyId() != null) {
                jsonWriter.key("KmsKeyId").value((Object)createReplicationInstanceRequest.getKmsKeyId());
            }
            if (createReplicationInstanceRequest.getPubliclyAccessible() != null) {
                jsonWriter.key("PubliclyAccessible").value((Object)createReplicationInstanceRequest.getPubliclyAccessible());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

