/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.databasemigrationservice.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.databasemigrationservice.model.CreateReplicationTaskRequest;
import com.amazonaws.services.databasemigrationservice.model.Tag;
import com.amazonaws.services.databasemigrationservice.model.transform.TagJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;

public class CreateReplicationTaskRequestMarshaller
implements Marshaller<Request<CreateReplicationTaskRequest>, CreateReplicationTaskRequest> {
    public Request<CreateReplicationTaskRequest> marshall(CreateReplicationTaskRequest createReplicationTaskRequest) {
        if (createReplicationTaskRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createReplicationTaskRequest, "AWSDatabaseMigrationService");
        request.addHeader("X-Amz-Target", "AmazonDMSv20160101.CreateReplicationTask");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<Tag> tagsList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (createReplicationTaskRequest.getReplicationTaskIdentifier() != null) {
                jsonWriter.key("ReplicationTaskIdentifier").value((Object)createReplicationTaskRequest.getReplicationTaskIdentifier());
            }
            if (createReplicationTaskRequest.getSourceEndpointArn() != null) {
                jsonWriter.key("SourceEndpointArn").value((Object)createReplicationTaskRequest.getSourceEndpointArn());
            }
            if (createReplicationTaskRequest.getTargetEndpointArn() != null) {
                jsonWriter.key("TargetEndpointArn").value((Object)createReplicationTaskRequest.getTargetEndpointArn());
            }
            if (createReplicationTaskRequest.getReplicationInstanceArn() != null) {
                jsonWriter.key("ReplicationInstanceArn").value((Object)createReplicationTaskRequest.getReplicationInstanceArn());
            }
            if (createReplicationTaskRequest.getMigrationType() != null) {
                jsonWriter.key("MigrationType").value((Object)createReplicationTaskRequest.getMigrationType());
            }
            if (createReplicationTaskRequest.getTableMappings() != null) {
                jsonWriter.key("TableMappings").value((Object)createReplicationTaskRequest.getTableMappings());
            }
            if (createReplicationTaskRequest.getReplicationTaskSettings() != null) {
                jsonWriter.key("ReplicationTaskSettings").value((Object)createReplicationTaskRequest.getReplicationTaskSettings());
            }
            if (createReplicationTaskRequest.getCdcStartTime() != null) {
                jsonWriter.key("CdcStartTime").value(createReplicationTaskRequest.getCdcStartTime());
            }
            if ((tagsList = createReplicationTaskRequest.getTags()) != null) {
                jsonWriter.key("Tags");
                jsonWriter.array();
                for (Tag tagsListValue : tagsList) {
                    if (tagsListValue == null) continue;
                    TagJsonMarshaller.getInstance().marshall(tagsListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

