/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.databasemigrationservice.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.databasemigrationservice.model.DescribeReplicationInstancesRequest;
import com.amazonaws.services.databasemigrationservice.model.Filter;
import com.amazonaws.services.databasemigrationservice.model.transform.FilterJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;

public class DescribeReplicationInstancesRequestMarshaller
implements Marshaller<Request<DescribeReplicationInstancesRequest>, DescribeReplicationInstancesRequest> {
    public Request<DescribeReplicationInstancesRequest> marshall(DescribeReplicationInstancesRequest describeReplicationInstancesRequest) {
        if (describeReplicationInstancesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeReplicationInstancesRequest, "AWSDatabaseMigrationService");
        request.addHeader("X-Amz-Target", "AmazonDMSv20160101.DescribeReplicationInstances");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            List<Filter> filtersList = describeReplicationInstancesRequest.getFilters();
            if (filtersList != null) {
                jsonWriter.key("Filters");
                jsonWriter.array();
                for (Filter filtersListValue : filtersList) {
                    if (filtersListValue == null) continue;
                    FilterJsonMarshaller.getInstance().marshall(filtersListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (describeReplicationInstancesRequest.getMaxRecords() != null) {
                jsonWriter.key("MaxRecords").value((Object)describeReplicationInstancesRequest.getMaxRecords());
            }
            if (describeReplicationInstancesRequest.getMarker() != null) {
                jsonWriter.key("Marker").value((Object)describeReplicationInstancesRequest.getMarker());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

