/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.databasemigrationservice.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.databasemigrationservice.model.ReplicationInstance;
import com.amazonaws.services.databasemigrationservice.model.transform.ReplicationPendingModifiedValuesJsonMarshaller;
import com.amazonaws.services.databasemigrationservice.model.transform.ReplicationSubnetGroupJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class ReplicationInstanceJsonMarshaller {
    private static ReplicationInstanceJsonMarshaller instance;

    public void marshall(ReplicationInstance replicationInstance, JSONWriter jsonWriter) {
        if (replicationInstance == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (replicationInstance.getReplicationInstanceIdentifier() != null) {
                jsonWriter.key("ReplicationInstanceIdentifier").value((Object)replicationInstance.getReplicationInstanceIdentifier());
            }
            if (replicationInstance.getReplicationInstanceClass() != null) {
                jsonWriter.key("ReplicationInstanceClass").value((Object)replicationInstance.getReplicationInstanceClass());
            }
            if (replicationInstance.getReplicationInstanceStatus() != null) {
                jsonWriter.key("ReplicationInstanceStatus").value((Object)replicationInstance.getReplicationInstanceStatus());
            }
            if (replicationInstance.getAllocatedStorage() != null) {
                jsonWriter.key("AllocatedStorage").value((Object)replicationInstance.getAllocatedStorage());
            }
            if (replicationInstance.getInstanceCreateTime() != null) {
                jsonWriter.key("InstanceCreateTime").value(replicationInstance.getInstanceCreateTime());
            }
            if (replicationInstance.getAvailabilityZone() != null) {
                jsonWriter.key("AvailabilityZone").value((Object)replicationInstance.getAvailabilityZone());
            }
            if (replicationInstance.getReplicationSubnetGroup() != null) {
                jsonWriter.key("ReplicationSubnetGroup");
                ReplicationSubnetGroupJsonMarshaller.getInstance().marshall(replicationInstance.getReplicationSubnetGroup(), jsonWriter);
            }
            if (replicationInstance.getPreferredMaintenanceWindow() != null) {
                jsonWriter.key("PreferredMaintenanceWindow").value((Object)replicationInstance.getPreferredMaintenanceWindow());
            }
            if (replicationInstance.getPendingModifiedValues() != null) {
                jsonWriter.key("PendingModifiedValues");
                ReplicationPendingModifiedValuesJsonMarshaller.getInstance().marshall(replicationInstance.getPendingModifiedValues(), jsonWriter);
            }
            if (replicationInstance.getEngineVersion() != null) {
                jsonWriter.key("EngineVersion").value((Object)replicationInstance.getEngineVersion());
            }
            if (replicationInstance.getAutoMinorVersionUpgrade() != null) {
                jsonWriter.key("AutoMinorVersionUpgrade").value((Object)replicationInstance.getAutoMinorVersionUpgrade());
            }
            if (replicationInstance.getKmsKeyId() != null) {
                jsonWriter.key("KmsKeyId").value((Object)replicationInstance.getKmsKeyId());
            }
            if (replicationInstance.getReplicationInstanceArn() != null) {
                jsonWriter.key("ReplicationInstanceArn").value((Object)replicationInstance.getReplicationInstanceArn());
            }
            if (replicationInstance.getReplicationInstancePublicIpAddress() != null) {
                jsonWriter.key("ReplicationInstancePublicIpAddress").value((Object)replicationInstance.getReplicationInstancePublicIpAddress());
            }
            if (replicationInstance.getReplicationInstancePrivateIpAddress() != null) {
                jsonWriter.key("ReplicationInstancePrivateIpAddress").value((Object)replicationInstance.getReplicationInstancePrivateIpAddress());
            }
            if (replicationInstance.getPubliclyAccessible() != null) {
                jsonWriter.key("PubliclyAccessible").value((Object)replicationInstance.getPubliclyAccessible());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ReplicationInstanceJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ReplicationInstanceJsonMarshaller();
        }
        return instance;
    }
}

