/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.databasemigrationservice.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.databasemigrationservice.model.ReplicationSubnetGroup;
import com.amazonaws.services.databasemigrationservice.model.Subnet;
import com.amazonaws.services.databasemigrationservice.model.transform.SubnetJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;
import java.util.List;

public class ReplicationSubnetGroupJsonMarshaller {
    private static ReplicationSubnetGroupJsonMarshaller instance;

    public void marshall(ReplicationSubnetGroup replicationSubnetGroup, JSONWriter jsonWriter) {
        if (replicationSubnetGroup == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<Subnet> subnetsList;
            jsonWriter.object();
            if (replicationSubnetGroup.getReplicationSubnetGroupIdentifier() != null) {
                jsonWriter.key("ReplicationSubnetGroupIdentifier").value((Object)replicationSubnetGroup.getReplicationSubnetGroupIdentifier());
            }
            if (replicationSubnetGroup.getReplicationSubnetGroupDescription() != null) {
                jsonWriter.key("ReplicationSubnetGroupDescription").value((Object)replicationSubnetGroup.getReplicationSubnetGroupDescription());
            }
            if (replicationSubnetGroup.getVpcId() != null) {
                jsonWriter.key("VpcId").value((Object)replicationSubnetGroup.getVpcId());
            }
            if (replicationSubnetGroup.getSubnetGroupStatus() != null) {
                jsonWriter.key("SubnetGroupStatus").value((Object)replicationSubnetGroup.getSubnetGroupStatus());
            }
            if ((subnetsList = replicationSubnetGroup.getSubnets()) != null) {
                jsonWriter.key("Subnets");
                jsonWriter.array();
                for (Subnet subnetsListValue : subnetsList) {
                    if (subnetsListValue == null) continue;
                    SubnetJsonMarshaller.getInstance().marshall(subnetsListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ReplicationSubnetGroupJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ReplicationSubnetGroupJsonMarshaller();
        }
        return instance;
    }
}

