/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.databasemigrationservice.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.databasemigrationservice.model.ReplicationTask;
import com.amazonaws.services.databasemigrationservice.model.transform.ReplicationTaskStatsJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class ReplicationTaskJsonMarshaller {
    private static ReplicationTaskJsonMarshaller instance;

    public void marshall(ReplicationTask replicationTask, JSONWriter jsonWriter) {
        if (replicationTask == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (replicationTask.getReplicationTaskIdentifier() != null) {
                jsonWriter.key("ReplicationTaskIdentifier").value((Object)replicationTask.getReplicationTaskIdentifier());
            }
            if (replicationTask.getSourceEndpointArn() != null) {
                jsonWriter.key("SourceEndpointArn").value((Object)replicationTask.getSourceEndpointArn());
            }
            if (replicationTask.getTargetEndpointArn() != null) {
                jsonWriter.key("TargetEndpointArn").value((Object)replicationTask.getTargetEndpointArn());
            }
            if (replicationTask.getReplicationInstanceArn() != null) {
                jsonWriter.key("ReplicationInstanceArn").value((Object)replicationTask.getReplicationInstanceArn());
            }
            if (replicationTask.getMigrationType() != null) {
                jsonWriter.key("MigrationType").value((Object)replicationTask.getMigrationType());
            }
            if (replicationTask.getTableMappings() != null) {
                jsonWriter.key("TableMappings").value((Object)replicationTask.getTableMappings());
            }
            if (replicationTask.getReplicationTaskSettings() != null) {
                jsonWriter.key("ReplicationTaskSettings").value((Object)replicationTask.getReplicationTaskSettings());
            }
            if (replicationTask.getStatus() != null) {
                jsonWriter.key("Status").value((Object)replicationTask.getStatus());
            }
            if (replicationTask.getLastFailureMessage() != null) {
                jsonWriter.key("LastFailureMessage").value((Object)replicationTask.getLastFailureMessage());
            }
            if (replicationTask.getReplicationTaskCreationDate() != null) {
                jsonWriter.key("ReplicationTaskCreationDate").value(replicationTask.getReplicationTaskCreationDate());
            }
            if (replicationTask.getReplicationTaskStartDate() != null) {
                jsonWriter.key("ReplicationTaskStartDate").value(replicationTask.getReplicationTaskStartDate());
            }
            if (replicationTask.getReplicationTaskArn() != null) {
                jsonWriter.key("ReplicationTaskArn").value((Object)replicationTask.getReplicationTaskArn());
            }
            if (replicationTask.getReplicationTaskStats() != null) {
                jsonWriter.key("ReplicationTaskStats");
                ReplicationTaskStatsJsonMarshaller.getInstance().marshall(replicationTask.getReplicationTaskStats(), jsonWriter);
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ReplicationTaskJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ReplicationTaskJsonMarshaller();
        }
        return instance;
    }
}

