/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.databasemigrationservice.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.databasemigrationservice.model.Subnet;
import com.amazonaws.services.databasemigrationservice.model.transform.AvailabilityZoneJsonMarshaller;
import com.amazonaws.util.json.SdkJsonGenerator;

public class SubnetJsonMarshaller {
    private static SubnetJsonMarshaller instance;

    public void marshall(Subnet subnet, SdkJsonGenerator jsonGenerator) {
        if (subnet == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (subnet.getSubnetIdentifier() != null) {
                jsonGenerator.writeFieldName("SubnetIdentifier").writeValue(subnet.getSubnetIdentifier());
            }
            if (subnet.getSubnetAvailabilityZone() != null) {
                jsonGenerator.writeFieldName("SubnetAvailabilityZone");
                AvailabilityZoneJsonMarshaller.getInstance().marshall(subnet.getSubnetAvailabilityZone(), jsonGenerator);
            }
            if (subnet.getSubnetStatus() != null) {
                jsonGenerator.writeFieldName("SubnetStatus").writeValue(subnet.getSubnetStatus());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static SubnetJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new SubnetJsonMarshaller();
        }
        return instance;
    }
}

