/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.databasemigrationservice.model;

import com.amazonaws.services.databasemigrationservice.model.Connection;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DescribeConnectionsResult
implements Serializable,
Cloneable {
    private String marker;
    private List<Connection> connections;

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public String getMarker() {
        return this.marker;
    }

    public DescribeConnectionsResult withMarker(String marker) {
        this.setMarker(marker);
        return this;
    }

    public List<Connection> getConnections() {
        return this.connections;
    }

    public void setConnections(Collection<Connection> connections) {
        if (connections == null) {
            this.connections = null;
            return;
        }
        this.connections = new ArrayList<Connection>(connections);
    }

    public DescribeConnectionsResult withConnections(Connection ... connections) {
        if (this.connections == null) {
            this.setConnections(new ArrayList<Connection>(connections.length));
        }
        for (Connection ele : connections) {
            this.connections.add(ele);
        }
        return this;
    }

    public DescribeConnectionsResult withConnections(Collection<Connection> connections) {
        this.setConnections(connections);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMarker() != null) {
            sb.append("Marker: " + this.getMarker() + ",");
        }
        if (this.getConnections() != null) {
            sb.append("Connections: " + this.getConnections());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConnectionsResult)) {
            return false;
        }
        DescribeConnectionsResult other = (DescribeConnectionsResult)obj;
        if (other.getMarker() == null ^ this.getMarker() == null) {
            return false;
        }
        if (other.getMarker() != null && !other.getMarker().equals(this.getMarker())) {
            return false;
        }
        if (other.getConnections() == null ^ this.getConnections() == null) {
            return false;
        }
        return other.getConnections() == null || other.getConnections().equals(this.getConnections());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMarker() == null ? 0 : this.getMarker().hashCode());
        hashCode = 31 * hashCode + (this.getConnections() == null ? 0 : this.getConnections().hashCode());
        return hashCode;
    }

    public DescribeConnectionsResult clone() {
        try {
            return (DescribeConnectionsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

