/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.databasemigrationservice.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.databasemigrationservice.model.CreateReplicationInstanceRequest;
import com.amazonaws.services.databasemigrationservice.model.Tag;
import com.amazonaws.services.databasemigrationservice.model.transform.TagJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;

public class CreateReplicationInstanceRequestMarshaller
implements Marshaller<Request<CreateReplicationInstanceRequest>, CreateReplicationInstanceRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public CreateReplicationInstanceRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<CreateReplicationInstanceRequest> marshall(CreateReplicationInstanceRequest createReplicationInstanceRequest) {
        if (createReplicationInstanceRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createReplicationInstanceRequest, "AWSDatabaseMigrationService");
        request.addHeader("X-Amz-Target", "AmazonDMSv20160101.CreateReplicationInstance");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<Tag> tagsList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createReplicationInstanceRequest.getReplicationInstanceIdentifier() != null) {
                jsonGenerator.writeFieldName("ReplicationInstanceIdentifier").writeValue(createReplicationInstanceRequest.getReplicationInstanceIdentifier());
            }
            if (createReplicationInstanceRequest.getAllocatedStorage() != null) {
                jsonGenerator.writeFieldName("AllocatedStorage").writeValue(createReplicationInstanceRequest.getAllocatedStorage().intValue());
            }
            if (createReplicationInstanceRequest.getReplicationInstanceClass() != null) {
                jsonGenerator.writeFieldName("ReplicationInstanceClass").writeValue(createReplicationInstanceRequest.getReplicationInstanceClass());
            }
            if (createReplicationInstanceRequest.getAvailabilityZone() != null) {
                jsonGenerator.writeFieldName("AvailabilityZone").writeValue(createReplicationInstanceRequest.getAvailabilityZone());
            }
            if (createReplicationInstanceRequest.getReplicationSubnetGroupIdentifier() != null) {
                jsonGenerator.writeFieldName("ReplicationSubnetGroupIdentifier").writeValue(createReplicationInstanceRequest.getReplicationSubnetGroupIdentifier());
            }
            if (createReplicationInstanceRequest.getPreferredMaintenanceWindow() != null) {
                jsonGenerator.writeFieldName("PreferredMaintenanceWindow").writeValue(createReplicationInstanceRequest.getPreferredMaintenanceWindow());
            }
            if (createReplicationInstanceRequest.getEngineVersion() != null) {
                jsonGenerator.writeFieldName("EngineVersion").writeValue(createReplicationInstanceRequest.getEngineVersion());
            }
            if (createReplicationInstanceRequest.getAutoMinorVersionUpgrade() != null) {
                jsonGenerator.writeFieldName("AutoMinorVersionUpgrade").writeValue(createReplicationInstanceRequest.getAutoMinorVersionUpgrade().booleanValue());
            }
            if ((tagsList = createReplicationInstanceRequest.getTags()) != null) {
                jsonGenerator.writeFieldName("Tags");
                jsonGenerator.writeStartArray();
                for (Tag tagsListValue : tagsList) {
                    if (tagsListValue == null) continue;
                    TagJsonMarshaller.getInstance().marshall(tagsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (createReplicationInstanceRequest.getKmsKeyId() != null) {
                jsonGenerator.writeFieldName("KmsKeyId").writeValue(createReplicationInstanceRequest.getKmsKeyId());
            }
            if (createReplicationInstanceRequest.getPubliclyAccessible() != null) {
                jsonGenerator.writeFieldName("PubliclyAccessible").writeValue(createReplicationInstanceRequest.getPubliclyAccessible().booleanValue());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

