/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.databasemigrationservice.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.databasemigrationservice.model.ModifyReplicationInstanceRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;

public class ModifyReplicationInstanceRequestMarshaller
implements Marshaller<Request<ModifyReplicationInstanceRequest>, ModifyReplicationInstanceRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public ModifyReplicationInstanceRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<ModifyReplicationInstanceRequest> marshall(ModifyReplicationInstanceRequest modifyReplicationInstanceRequest) {
        if (modifyReplicationInstanceRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyReplicationInstanceRequest, "AWSDatabaseMigrationService");
        request.addHeader("X-Amz-Target", "AmazonDMSv20160101.ModifyReplicationInstance");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<String> vpcSecurityGroupIdsList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (modifyReplicationInstanceRequest.getReplicationInstanceArn() != null) {
                jsonGenerator.writeFieldName("ReplicationInstanceArn").writeValue(modifyReplicationInstanceRequest.getReplicationInstanceArn());
            }
            if (modifyReplicationInstanceRequest.getAllocatedStorage() != null) {
                jsonGenerator.writeFieldName("AllocatedStorage").writeValue(modifyReplicationInstanceRequest.getAllocatedStorage().intValue());
            }
            if (modifyReplicationInstanceRequest.getApplyImmediately() != null) {
                jsonGenerator.writeFieldName("ApplyImmediately").writeValue(modifyReplicationInstanceRequest.getApplyImmediately().booleanValue());
            }
            if (modifyReplicationInstanceRequest.getReplicationInstanceClass() != null) {
                jsonGenerator.writeFieldName("ReplicationInstanceClass").writeValue(modifyReplicationInstanceRequest.getReplicationInstanceClass());
            }
            if ((vpcSecurityGroupIdsList = modifyReplicationInstanceRequest.getVpcSecurityGroupIds()) != null) {
                jsonGenerator.writeFieldName("VpcSecurityGroupIds");
                jsonGenerator.writeStartArray();
                for (String vpcSecurityGroupIdsListValue : vpcSecurityGroupIdsList) {
                    if (vpcSecurityGroupIdsListValue == null) continue;
                    jsonGenerator.writeValue(vpcSecurityGroupIdsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (modifyReplicationInstanceRequest.getPreferredMaintenanceWindow() != null) {
                jsonGenerator.writeFieldName("PreferredMaintenanceWindow").writeValue(modifyReplicationInstanceRequest.getPreferredMaintenanceWindow());
            }
            if (modifyReplicationInstanceRequest.getMultiAZ() != null) {
                jsonGenerator.writeFieldName("MultiAZ").writeValue(modifyReplicationInstanceRequest.getMultiAZ().booleanValue());
            }
            if (modifyReplicationInstanceRequest.getEngineVersion() != null) {
                jsonGenerator.writeFieldName("EngineVersion").writeValue(modifyReplicationInstanceRequest.getEngineVersion());
            }
            if (modifyReplicationInstanceRequest.getAllowMajorVersionUpgrade() != null) {
                jsonGenerator.writeFieldName("AllowMajorVersionUpgrade").writeValue(modifyReplicationInstanceRequest.getAllowMajorVersionUpgrade().booleanValue());
            }
            if (modifyReplicationInstanceRequest.getAutoMinorVersionUpgrade() != null) {
                jsonGenerator.writeFieldName("AutoMinorVersionUpgrade").writeValue(modifyReplicationInstanceRequest.getAutoMinorVersionUpgrade().booleanValue());
            }
            if (modifyReplicationInstanceRequest.getReplicationInstanceIdentifier() != null) {
                jsonGenerator.writeFieldName("ReplicationInstanceIdentifier").writeValue(modifyReplicationInstanceRequest.getReplicationInstanceIdentifier());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

