/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMappingException;
import com.amazonaws.services.dynamodbv2.datamodeling.ReflectionUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;

@SdkInternalApi
final class DynamoDBReflectionRegistry {
    DynamoDBReflectionRegistry() {
    }

    final Collection<BeanProperty> beanPropertiesOf(Class<?> clazz) {
        ArrayList<BeanProperty> beanProperties = new ArrayList<BeanProperty>();
        for (Method method : clazz.getMethods()) {
            if (!DynamoDBReflectionRegistry.isBeanPropertyGetter(method)) continue;
            beanProperties.add(new BeanProperty(method));
        }
        return beanProperties;
    }

    private static final boolean isBeanPropertyGetter(Method method) {
        if (!method.getName().startsWith("get") && !method.getName().startsWith("is")) {
            return false;
        }
        if (method.getParameterTypes().length != 0) {
            return false;
        }
        if (method.isBridge()) {
            return false;
        }
        if (method.isSynthetic()) {
            return false;
        }
        return !Object.class.equals(method.getDeclaringClass());
    }

    static final class BeanProperty {
        private final Method getter;
        private final Method setter;
        private final Field field;
        private final Class<?> getterType;
        private final Class<?> setterType;
        private final String fieldName;

        private BeanProperty(Method getterMethod) {
            this.getter = getterMethod;
            this.setter = ReflectionUtils.getDeclaredSetterByGetter(this.getGetter());
            this.fieldName = ReflectionUtils.getFieldNameByGetter(this.getGetter(), true);
            this.field = ReflectionUtils.getClassFieldByName(this.getGetter().getDeclaringClass(), this.getFieldName());
            this.getterType = this.getGetter().getReturnType();
            this.setterType = this.setter == null || this.setter.getParameterTypes().length != 1 ? null : this.setter.getParameterTypes()[0];
        }

        final Method getGetter() {
            return this.getter;
        }

        final Method getSetter() {
            if (this.setter == null) {
                throw new DynamoDBMappingException("No access to public, one-argument method called set" + ReflectionUtils.getFieldNameByGetter(this.getGetter(), false) + " on class " + this.getGetter().getDeclaringClass());
            }
            return this.setter;
        }

        final Field getField() {
            return this.field;
        }

        final Class<?> getGetterType() {
            return this.getterType;
        }

        final Class<?> getSetterType() {
            return this.setterType;
        }

        final String getFieldName() {
            return this.fieldName;
        }

        final Object getValueOf(Object target) {
            try {
                return this.getGetter().invoke(target, new Object[0]);
            }
            catch (Exception e) {
                throw new DynamoDBMappingException("Could not invoke " + this.getter + " on " + (target == null ? null : target.getClass()), e);
            }
        }

        final void setValueOf(Object target, Object value) {
            Method method = this.getSetter();
            try {
                method.invoke(target, value);
            }
            catch (Exception e) {
                throw new DynamoDBMappingException("Could not invoke " + method + " on " + (target == null ? null : target.getClass()), e);
            }
        }
    }
}

