/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.Region;
import com.amazonaws.services.s3.transfer.TransferManager;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class S3ClientCache {
    private final ConcurrentMap<Region, AmazonS3Client> clientsByRegion = new ConcurrentHashMap<Region, AmazonS3Client>();
    private final Map<Region, TransferManager> transferManagersByRegion = new EnumMap<Region, TransferManager>(Region.class);
    private final AWSCredentialsProvider awscredentialsProvider;

    @Deprecated
    S3ClientCache(AWSCredentials credentials) {
        this((AWSCredentialsProvider)new StaticCredentialsProvider(credentials));
    }

    S3ClientCache(AWSCredentialsProvider awsCredentialsProvider) {
        this.awscredentialsProvider = awsCredentialsProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void useClient(AmazonS3Client client) {
        Region s3region = client.getRegion();
        Map<Region, TransferManager> map = this.transferManagersByRegion;
        synchronized (map) {
            TransferManager tm = this.transferManagersByRegion.remove(s3region);
            if (tm != null) {
                tm.shutdownNow();
            }
            this.clientsByRegion.put(s3region, client);
        }
    }

    public AmazonS3Client getClient(Region s3region) {
        if (s3region == null) {
            throw new IllegalArgumentException("S3 region must be specified");
        }
        AmazonS3Client client = (AmazonS3Client)this.clientsByRegion.get(s3region);
        if (client != null) {
            return client;
        }
        if (this.awscredentialsProvider == null) {
            throw new IllegalArgumentException("No credentials provider found to connect to S3");
        }
        client = new AmazonS3Client(this.awscredentialsProvider);
        client.setRegion(s3region.toAWSRegion());
        AmazonS3Client prev = this.clientsByRegion.putIfAbsent(s3region, client);
        return prev == null ? client : prev;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransferManager getTransferManager(Region region) {
        Map<Region, TransferManager> map = this.transferManagersByRegion;
        synchronized (map) {
            TransferManager tm = this.transferManagersByRegion.get(region);
            if (tm == null) {
                tm = new TransferManager((AmazonS3)this.getClient(region));
                this.transferManagersByRegion.put(region, tm);
            }
            return tm;
        }
    }
}

