/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.dynamodbv2.model.DescribeStreamRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class DescribeStreamRequestMarshaller
implements Marshaller<Request<DescribeStreamRequest>, DescribeStreamRequest> {
    public Request<DescribeStreamRequest> marshall(DescribeStreamRequest describeStreamRequest) {
        if (describeStreamRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeStreamRequest, "AmazonDynamoDBStreams");
        request.addHeader("X-Amz-Target", "DynamoDBStreams_20120810.DescribeStream");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter((boolean)false, (String)"1.0");
            jsonGenerator.writeStartObject();
            if (describeStreamRequest.getStreamArn() != null) {
                jsonGenerator.writeFieldName("StreamArn").writeValue(describeStreamRequest.getStreamArn());
            }
            if (describeStreamRequest.getLimit() != null) {
                jsonGenerator.writeFieldName("Limit").writeValue(describeStreamRequest.getLimit().intValue());
            }
            if (describeStreamRequest.getExclusiveStartShardId() != null) {
                jsonGenerator.writeFieldName("ExclusiveStartShardId").writeValue(describeStreamRequest.getExclusiveStartShardId());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

