/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.Condition;
import com.amazonaws.services.dynamodbv2.model.ScanRequest;
import com.amazonaws.services.dynamodbv2.model.transform.AttributeValueJsonMarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.ConditionJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.Map;

public class ScanRequestMarshaller
implements Marshaller<Request<ScanRequest>, ScanRequest> {
    public Request<ScanRequest> marshall(ScanRequest scanRequest) {
        if (scanRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)scanRequest, "AmazonDynamoDBv2");
        request.addHeader("X-Amz-Target", "DynamoDB_20120810.Scan");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            Map<String, AttributeValue> expressionAttributeValuesMap;
            Map<String, String> expressionAttributeNamesMap;
            Map<String, AttributeValue> exclusiveStartKeyMap;
            Map<String, Condition> scanFilterMap;
            List<String> attributesToGetList;
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter((boolean)false, (String)"1.0");
            jsonGenerator.writeStartObject();
            if (scanRequest.getTableName() != null) {
                jsonGenerator.writeFieldName("TableName").writeValue(scanRequest.getTableName());
            }
            if (scanRequest.getIndexName() != null) {
                jsonGenerator.writeFieldName("IndexName").writeValue(scanRequest.getIndexName());
            }
            if ((attributesToGetList = scanRequest.getAttributesToGet()) != null) {
                jsonGenerator.writeFieldName("AttributesToGet");
                jsonGenerator.writeStartArray();
                for (String attributesToGetListValue : attributesToGetList) {
                    if (attributesToGetListValue == null) continue;
                    jsonGenerator.writeValue(attributesToGetListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (scanRequest.getLimit() != null) {
                jsonGenerator.writeFieldName("Limit").writeValue(scanRequest.getLimit().intValue());
            }
            if (scanRequest.getSelect() != null) {
                jsonGenerator.writeFieldName("Select").writeValue(scanRequest.getSelect());
            }
            if ((scanFilterMap = scanRequest.getScanFilter()) != null) {
                jsonGenerator.writeFieldName("ScanFilter");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, Condition> scanFilterMapValue : scanFilterMap.entrySet()) {
                    if (scanFilterMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(scanFilterMapValue.getKey());
                    ConditionJsonMarshaller.getInstance().marshall(scanFilterMapValue.getValue(), jsonGenerator);
                }
                jsonGenerator.writeEndObject();
            }
            if (scanRequest.getConditionalOperator() != null) {
                jsonGenerator.writeFieldName("ConditionalOperator").writeValue(scanRequest.getConditionalOperator());
            }
            if ((exclusiveStartKeyMap = scanRequest.getExclusiveStartKey()) != null) {
                jsonGenerator.writeFieldName("ExclusiveStartKey");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, AttributeValue> exclusiveStartKeyMapValue : exclusiveStartKeyMap.entrySet()) {
                    if (exclusiveStartKeyMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(exclusiveStartKeyMapValue.getKey());
                    AttributeValueJsonMarshaller.getInstance().marshall(exclusiveStartKeyMapValue.getValue(), jsonGenerator);
                }
                jsonGenerator.writeEndObject();
            }
            if (scanRequest.getReturnConsumedCapacity() != null) {
                jsonGenerator.writeFieldName("ReturnConsumedCapacity").writeValue(scanRequest.getReturnConsumedCapacity());
            }
            if (scanRequest.getTotalSegments() != null) {
                jsonGenerator.writeFieldName("TotalSegments").writeValue(scanRequest.getTotalSegments().intValue());
            }
            if (scanRequest.getSegment() != null) {
                jsonGenerator.writeFieldName("Segment").writeValue(scanRequest.getSegment().intValue());
            }
            if (scanRequest.getProjectionExpression() != null) {
                jsonGenerator.writeFieldName("ProjectionExpression").writeValue(scanRequest.getProjectionExpression());
            }
            if (scanRequest.getFilterExpression() != null) {
                jsonGenerator.writeFieldName("FilterExpression").writeValue(scanRequest.getFilterExpression());
            }
            if ((expressionAttributeNamesMap = scanRequest.getExpressionAttributeNames()) != null) {
                jsonGenerator.writeFieldName("ExpressionAttributeNames");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, String> expressionAttributeNamesMapValue : expressionAttributeNamesMap.entrySet()) {
                    if (expressionAttributeNamesMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(expressionAttributeNamesMapValue.getKey());
                    jsonGenerator.writeValue(expressionAttributeNamesMapValue.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            if ((expressionAttributeValuesMap = scanRequest.getExpressionAttributeValues()) != null) {
                jsonGenerator.writeFieldName("ExpressionAttributeValues");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, AttributeValue> expressionAttributeValuesMapValue : expressionAttributeValuesMap.entrySet()) {
                    if (expressionAttributeValuesMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(expressionAttributeValuesMapValue.getKey());
                    AttributeValueJsonMarshaller.getInstance().marshall(expressionAttributeValuesMapValue.getValue(), jsonGenerator);
                }
                jsonGenerator.writeEndObject();
            }
            if (scanRequest.getConsistentRead() != null) {
                jsonGenerator.writeFieldName("ConsistentRead").writeValue(scanRequest.getConsistentRead().booleanValue());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

